/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetFullIssuedCardRequest {
    /**
     * The Moov business account for which the card was issued.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=issuedCardID")
    private String issuedCardID;

    @JsonCreator
    public GetFullIssuedCardRequest(
            String accountID,
            String issuedCardID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(issuedCardID, "issuedCardID");
        this.accountID = accountID;
        this.issuedCardID = issuedCardID;
    }

    /**
     * The Moov business account for which the card was issued.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String issuedCardID() {
        return issuedCardID;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The Moov business account for which the card was issued.
     */
    public GetFullIssuedCardRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public GetFullIssuedCardRequest withIssuedCardID(String issuedCardID) {
        Utils.checkNotNull(issuedCardID, "issuedCardID");
        this.issuedCardID = issuedCardID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetFullIssuedCardRequest other = (GetFullIssuedCardRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.issuedCardID, other.issuedCardID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, issuedCardID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetFullIssuedCardRequest.class,
                "accountID", accountID,
                "issuedCardID", issuedCardID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String issuedCardID;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The Moov business account for which the card was issued.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder issuedCardID(String issuedCardID) {
            Utils.checkNotNull(issuedCardID, "issuedCardID");
            this.issuedCardID = issuedCardID;
            return this;
        }

        public GetFullIssuedCardRequest build() {

            return new GetFullIssuedCardRequest(
                accountID, issuedCardID);
        }

    }
}
