/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetFileDetailsRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=fileID")
    private String fileID;

    @JsonCreator
    public GetFileDetailsRequest(
            String accountID,
            String fileID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(fileID, "fileID");
        this.accountID = accountID;
        this.fileID = fileID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String fileID() {
        return fileID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public GetFileDetailsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public GetFileDetailsRequest withFileID(String fileID) {
        Utils.checkNotNull(fileID, "fileID");
        this.fileID = fileID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetFileDetailsRequest other = (GetFileDetailsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.fileID, other.fileID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, fileID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetFileDetailsRequest.class,
                "accountID", accountID,
                "fileID", fileID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String fileID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder fileID(String fileID) {
            Utils.checkNotNull(fileID, "fileID");
            this.fileID = fileID;
            return this;
        }

        public GetFileDetailsRequest build() {

            return new GetFileDetailsRequest(
                accountID, fileID);
        }

    }
}
