/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.EnrichedBusinessResponse;
import io.moov.sdk.utils.Response;
import io.moov.sdk.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class GetEnrichmentProfileResponse implements Response {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The request completed successfully.
     */
    private Optional<? extends EnrichedBusinessResponse> enrichedBusinessResponse;


    private Map<String, List<String>> headers;

    @JsonCreator
    public GetEnrichmentProfileResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends EnrichedBusinessResponse> enrichedBusinessResponse,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(enrichedBusinessResponse, "enrichedBusinessResponse");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.enrichedBusinessResponse = enrichedBusinessResponse;
        this.headers = headers;
    }
    
    public GetEnrichmentProfileResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The request completed successfully.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<EnrichedBusinessResponse> enrichedBusinessResponse() {
        return (Optional<EnrichedBusinessResponse>) enrichedBusinessResponse;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public GetEnrichmentProfileResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public GetEnrichmentProfileResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public GetEnrichmentProfileResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The request completed successfully.
     */
    public GetEnrichmentProfileResponse withEnrichedBusinessResponse(EnrichedBusinessResponse enrichedBusinessResponse) {
        Utils.checkNotNull(enrichedBusinessResponse, "enrichedBusinessResponse");
        this.enrichedBusinessResponse = Optional.ofNullable(enrichedBusinessResponse);
        return this;
    }


    /**
     * The request completed successfully.
     */
    public GetEnrichmentProfileResponse withEnrichedBusinessResponse(Optional<? extends EnrichedBusinessResponse> enrichedBusinessResponse) {
        Utils.checkNotNull(enrichedBusinessResponse, "enrichedBusinessResponse");
        this.enrichedBusinessResponse = enrichedBusinessResponse;
        return this;
    }

    public GetEnrichmentProfileResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetEnrichmentProfileResponse other = (GetEnrichmentProfileResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.enrichedBusinessResponse, other.enrichedBusinessResponse) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            enrichedBusinessResponse, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetEnrichmentProfileResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "enrichedBusinessResponse", enrichedBusinessResponse,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<InputStream> rawResponse;

        private Optional<? extends EnrichedBusinessResponse> enrichedBusinessResponse = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The request completed successfully.
         */
        public Builder enrichedBusinessResponse(EnrichedBusinessResponse enrichedBusinessResponse) {
            Utils.checkNotNull(enrichedBusinessResponse, "enrichedBusinessResponse");
            this.enrichedBusinessResponse = Optional.ofNullable(enrichedBusinessResponse);
            return this;
        }

        /**
         * The request completed successfully.
         */
        public Builder enrichedBusinessResponse(Optional<? extends EnrichedBusinessResponse> enrichedBusinessResponse) {
            Utils.checkNotNull(enrichedBusinessResponse, "enrichedBusinessResponse");
            this.enrichedBusinessResponse = enrichedBusinessResponse;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public GetEnrichmentProfileResponse build() {

            return new GetEnrichmentProfileResponse(
                contentType, statusCode, rawResponse,
                enrichedBusinessResponse, headers);
        }

    }
}
