/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class GetEnrichmentAddressRequest {
    /**
     * Partial or complete address to search.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=search")
    private String search;

    /**
     * Maximum number of results to return.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=maxResults")
    private Optional<Long> maxResults;

    /**
     * Limits results to a list of given cities.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=includeCities")
    private Optional<String> includeCities;

    /**
     * Limits results to a list of given states.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=includeStates")
    private Optional<String> includeStates;

    /**
     * Limits results to a list of given zipcodes.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=includeZipcodes")
    private Optional<String> includeZipcodes;

    /**
     * Exclude list of states from results. No `include` pararmeters may be used with this parameter.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=excludeStates")
    private Optional<String> excludeStates;

    /**
     * Display results with the listed cities at the top.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=preferCities")
    private Optional<String> preferCities;

    /**
     * Display results with the listed states at the top.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=preferStates")
    private Optional<String> preferStates;

    /**
     * Display results with the listed zipcodes at the top.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=preferZipcodes")
    private Optional<String> preferZipcodes;

    /**
     * Specifies the percentage of address suggestions that should be preferred and will appear at the top of the results.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=preferRatio")
    private Optional<Long> preferRatio;

    /**
     * If omitted or set to `city`, it uses the sender's IP address to determine location, then automatically adds the city and state 
     *   to the preferCities value. This parameter takes precedence over other `include` or `exclude` parameters meaning that if it is 
     *   not set to `none`, you may see addresses from areas you do not wish to see.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=preferGeolocation")
    private Optional<String> preferGeolocation;

    /**
     * Useful for narrowing results with `addressLine2` suggestions such as `Apt` (denotes an apartment building with multiple residences).
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=selected")
    private Optional<String> selected;

    /**
     * Include results from alternate data sources. Allowed values are `all` (non-postal addresses), or `postal` (postal addresses only).
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=source")
    private Optional<String> source;

    @JsonCreator
    public GetEnrichmentAddressRequest(
            String search,
            Optional<Long> maxResults,
            Optional<String> includeCities,
            Optional<String> includeStates,
            Optional<String> includeZipcodes,
            Optional<String> excludeStates,
            Optional<String> preferCities,
            Optional<String> preferStates,
            Optional<String> preferZipcodes,
            Optional<Long> preferRatio,
            Optional<String> preferGeolocation,
            Optional<String> selected,
            Optional<String> source) {
        Utils.checkNotNull(search, "search");
        Utils.checkNotNull(maxResults, "maxResults");
        Utils.checkNotNull(includeCities, "includeCities");
        Utils.checkNotNull(includeStates, "includeStates");
        Utils.checkNotNull(includeZipcodes, "includeZipcodes");
        Utils.checkNotNull(excludeStates, "excludeStates");
        Utils.checkNotNull(preferCities, "preferCities");
        Utils.checkNotNull(preferStates, "preferStates");
        Utils.checkNotNull(preferZipcodes, "preferZipcodes");
        Utils.checkNotNull(preferRatio, "preferRatio");
        Utils.checkNotNull(preferGeolocation, "preferGeolocation");
        Utils.checkNotNull(selected, "selected");
        Utils.checkNotNull(source, "source");
        this.search = search;
        this.maxResults = maxResults;
        this.includeCities = includeCities;
        this.includeStates = includeStates;
        this.includeZipcodes = includeZipcodes;
        this.excludeStates = excludeStates;
        this.preferCities = preferCities;
        this.preferStates = preferStates;
        this.preferZipcodes = preferZipcodes;
        this.preferRatio = preferRatio;
        this.preferGeolocation = preferGeolocation;
        this.selected = selected;
        this.source = source;
    }
    
    public GetEnrichmentAddressRequest(
            String search) {
        this(search, Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    /**
     * Partial or complete address to search.
     */
    @JsonIgnore
    public String search() {
        return search;
    }

    /**
     * Maximum number of results to return.
     */
    @JsonIgnore
    public Optional<Long> maxResults() {
        return maxResults;
    }

    /**
     * Limits results to a list of given cities.
     */
    @JsonIgnore
    public Optional<String> includeCities() {
        return includeCities;
    }

    /**
     * Limits results to a list of given states.
     */
    @JsonIgnore
    public Optional<String> includeStates() {
        return includeStates;
    }

    /**
     * Limits results to a list of given zipcodes.
     */
    @JsonIgnore
    public Optional<String> includeZipcodes() {
        return includeZipcodes;
    }

    /**
     * Exclude list of states from results. No `include` pararmeters may be used with this parameter.
     */
    @JsonIgnore
    public Optional<String> excludeStates() {
        return excludeStates;
    }

    /**
     * Display results with the listed cities at the top.
     */
    @JsonIgnore
    public Optional<String> preferCities() {
        return preferCities;
    }

    /**
     * Display results with the listed states at the top.
     */
    @JsonIgnore
    public Optional<String> preferStates() {
        return preferStates;
    }

    /**
     * Display results with the listed zipcodes at the top.
     */
    @JsonIgnore
    public Optional<String> preferZipcodes() {
        return preferZipcodes;
    }

    /**
     * Specifies the percentage of address suggestions that should be preferred and will appear at the top of the results.
     */
    @JsonIgnore
    public Optional<Long> preferRatio() {
        return preferRatio;
    }

    /**
     * If omitted or set to `city`, it uses the sender's IP address to determine location, then automatically adds the city and state 
     *   to the preferCities value. This parameter takes precedence over other `include` or `exclude` parameters meaning that if it is 
     *   not set to `none`, you may see addresses from areas you do not wish to see.
     */
    @JsonIgnore
    public Optional<String> preferGeolocation() {
        return preferGeolocation;
    }

    /**
     * Useful for narrowing results with `addressLine2` suggestions such as `Apt` (denotes an apartment building with multiple residences).
     */
    @JsonIgnore
    public Optional<String> selected() {
        return selected;
    }

    /**
     * Include results from alternate data sources. Allowed values are `all` (non-postal addresses), or `postal` (postal addresses only).
     */
    @JsonIgnore
    public Optional<String> source() {
        return source;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Partial or complete address to search.
     */
    public GetEnrichmentAddressRequest withSearch(String search) {
        Utils.checkNotNull(search, "search");
        this.search = search;
        return this;
    }

    /**
     * Maximum number of results to return.
     */
    public GetEnrichmentAddressRequest withMaxResults(long maxResults) {
        Utils.checkNotNull(maxResults, "maxResults");
        this.maxResults = Optional.ofNullable(maxResults);
        return this;
    }


    /**
     * Maximum number of results to return.
     */
    public GetEnrichmentAddressRequest withMaxResults(Optional<Long> maxResults) {
        Utils.checkNotNull(maxResults, "maxResults");
        this.maxResults = maxResults;
        return this;
    }

    /**
     * Limits results to a list of given cities.
     */
    public GetEnrichmentAddressRequest withIncludeCities(String includeCities) {
        Utils.checkNotNull(includeCities, "includeCities");
        this.includeCities = Optional.ofNullable(includeCities);
        return this;
    }


    /**
     * Limits results to a list of given cities.
     */
    public GetEnrichmentAddressRequest withIncludeCities(Optional<String> includeCities) {
        Utils.checkNotNull(includeCities, "includeCities");
        this.includeCities = includeCities;
        return this;
    }

    /**
     * Limits results to a list of given states.
     */
    public GetEnrichmentAddressRequest withIncludeStates(String includeStates) {
        Utils.checkNotNull(includeStates, "includeStates");
        this.includeStates = Optional.ofNullable(includeStates);
        return this;
    }


    /**
     * Limits results to a list of given states.
     */
    public GetEnrichmentAddressRequest withIncludeStates(Optional<String> includeStates) {
        Utils.checkNotNull(includeStates, "includeStates");
        this.includeStates = includeStates;
        return this;
    }

    /**
     * Limits results to a list of given zipcodes.
     */
    public GetEnrichmentAddressRequest withIncludeZipcodes(String includeZipcodes) {
        Utils.checkNotNull(includeZipcodes, "includeZipcodes");
        this.includeZipcodes = Optional.ofNullable(includeZipcodes);
        return this;
    }


    /**
     * Limits results to a list of given zipcodes.
     */
    public GetEnrichmentAddressRequest withIncludeZipcodes(Optional<String> includeZipcodes) {
        Utils.checkNotNull(includeZipcodes, "includeZipcodes");
        this.includeZipcodes = includeZipcodes;
        return this;
    }

    /**
     * Exclude list of states from results. No `include` pararmeters may be used with this parameter.
     */
    public GetEnrichmentAddressRequest withExcludeStates(String excludeStates) {
        Utils.checkNotNull(excludeStates, "excludeStates");
        this.excludeStates = Optional.ofNullable(excludeStates);
        return this;
    }


    /**
     * Exclude list of states from results. No `include` pararmeters may be used with this parameter.
     */
    public GetEnrichmentAddressRequest withExcludeStates(Optional<String> excludeStates) {
        Utils.checkNotNull(excludeStates, "excludeStates");
        this.excludeStates = excludeStates;
        return this;
    }

    /**
     * Display results with the listed cities at the top.
     */
    public GetEnrichmentAddressRequest withPreferCities(String preferCities) {
        Utils.checkNotNull(preferCities, "preferCities");
        this.preferCities = Optional.ofNullable(preferCities);
        return this;
    }


    /**
     * Display results with the listed cities at the top.
     */
    public GetEnrichmentAddressRequest withPreferCities(Optional<String> preferCities) {
        Utils.checkNotNull(preferCities, "preferCities");
        this.preferCities = preferCities;
        return this;
    }

    /**
     * Display results with the listed states at the top.
     */
    public GetEnrichmentAddressRequest withPreferStates(String preferStates) {
        Utils.checkNotNull(preferStates, "preferStates");
        this.preferStates = Optional.ofNullable(preferStates);
        return this;
    }


    /**
     * Display results with the listed states at the top.
     */
    public GetEnrichmentAddressRequest withPreferStates(Optional<String> preferStates) {
        Utils.checkNotNull(preferStates, "preferStates");
        this.preferStates = preferStates;
        return this;
    }

    /**
     * Display results with the listed zipcodes at the top.
     */
    public GetEnrichmentAddressRequest withPreferZipcodes(String preferZipcodes) {
        Utils.checkNotNull(preferZipcodes, "preferZipcodes");
        this.preferZipcodes = Optional.ofNullable(preferZipcodes);
        return this;
    }


    /**
     * Display results with the listed zipcodes at the top.
     */
    public GetEnrichmentAddressRequest withPreferZipcodes(Optional<String> preferZipcodes) {
        Utils.checkNotNull(preferZipcodes, "preferZipcodes");
        this.preferZipcodes = preferZipcodes;
        return this;
    }

    /**
     * Specifies the percentage of address suggestions that should be preferred and will appear at the top of the results.
     */
    public GetEnrichmentAddressRequest withPreferRatio(long preferRatio) {
        Utils.checkNotNull(preferRatio, "preferRatio");
        this.preferRatio = Optional.ofNullable(preferRatio);
        return this;
    }


    /**
     * Specifies the percentage of address suggestions that should be preferred and will appear at the top of the results.
     */
    public GetEnrichmentAddressRequest withPreferRatio(Optional<Long> preferRatio) {
        Utils.checkNotNull(preferRatio, "preferRatio");
        this.preferRatio = preferRatio;
        return this;
    }

    /**
     * If omitted or set to `city`, it uses the sender's IP address to determine location, then automatically adds the city and state 
     *   to the preferCities value. This parameter takes precedence over other `include` or `exclude` parameters meaning that if it is 
     *   not set to `none`, you may see addresses from areas you do not wish to see.
     */
    public GetEnrichmentAddressRequest withPreferGeolocation(String preferGeolocation) {
        Utils.checkNotNull(preferGeolocation, "preferGeolocation");
        this.preferGeolocation = Optional.ofNullable(preferGeolocation);
        return this;
    }


    /**
     * If omitted or set to `city`, it uses the sender's IP address to determine location, then automatically adds the city and state 
     *   to the preferCities value. This parameter takes precedence over other `include` or `exclude` parameters meaning that if it is 
     *   not set to `none`, you may see addresses from areas you do not wish to see.
     */
    public GetEnrichmentAddressRequest withPreferGeolocation(Optional<String> preferGeolocation) {
        Utils.checkNotNull(preferGeolocation, "preferGeolocation");
        this.preferGeolocation = preferGeolocation;
        return this;
    }

    /**
     * Useful for narrowing results with `addressLine2` suggestions such as `Apt` (denotes an apartment building with multiple residences).
     */
    public GetEnrichmentAddressRequest withSelected(String selected) {
        Utils.checkNotNull(selected, "selected");
        this.selected = Optional.ofNullable(selected);
        return this;
    }


    /**
     * Useful for narrowing results with `addressLine2` suggestions such as `Apt` (denotes an apartment building with multiple residences).
     */
    public GetEnrichmentAddressRequest withSelected(Optional<String> selected) {
        Utils.checkNotNull(selected, "selected");
        this.selected = selected;
        return this;
    }

    /**
     * Include results from alternate data sources. Allowed values are `all` (non-postal addresses), or `postal` (postal addresses only).
     */
    public GetEnrichmentAddressRequest withSource(String source) {
        Utils.checkNotNull(source, "source");
        this.source = Optional.ofNullable(source);
        return this;
    }


    /**
     * Include results from alternate data sources. Allowed values are `all` (non-postal addresses), or `postal` (postal addresses only).
     */
    public GetEnrichmentAddressRequest withSource(Optional<String> source) {
        Utils.checkNotNull(source, "source");
        this.source = source;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetEnrichmentAddressRequest other = (GetEnrichmentAddressRequest) o;
        return 
            Utils.enhancedDeepEquals(this.search, other.search) &&
            Utils.enhancedDeepEquals(this.maxResults, other.maxResults) &&
            Utils.enhancedDeepEquals(this.includeCities, other.includeCities) &&
            Utils.enhancedDeepEquals(this.includeStates, other.includeStates) &&
            Utils.enhancedDeepEquals(this.includeZipcodes, other.includeZipcodes) &&
            Utils.enhancedDeepEquals(this.excludeStates, other.excludeStates) &&
            Utils.enhancedDeepEquals(this.preferCities, other.preferCities) &&
            Utils.enhancedDeepEquals(this.preferStates, other.preferStates) &&
            Utils.enhancedDeepEquals(this.preferZipcodes, other.preferZipcodes) &&
            Utils.enhancedDeepEquals(this.preferRatio, other.preferRatio) &&
            Utils.enhancedDeepEquals(this.preferGeolocation, other.preferGeolocation) &&
            Utils.enhancedDeepEquals(this.selected, other.selected) &&
            Utils.enhancedDeepEquals(this.source, other.source);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            search, maxResults, includeCities,
            includeStates, includeZipcodes, excludeStates,
            preferCities, preferStates, preferZipcodes,
            preferRatio, preferGeolocation, selected,
            source);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetEnrichmentAddressRequest.class,
                "search", search,
                "maxResults", maxResults,
                "includeCities", includeCities,
                "includeStates", includeStates,
                "includeZipcodes", includeZipcodes,
                "excludeStates", excludeStates,
                "preferCities", preferCities,
                "preferStates", preferStates,
                "preferZipcodes", preferZipcodes,
                "preferRatio", preferRatio,
                "preferGeolocation", preferGeolocation,
                "selected", selected,
                "source", source);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String search;

        private Optional<Long> maxResults = Optional.empty();

        private Optional<String> includeCities = Optional.empty();

        private Optional<String> includeStates = Optional.empty();

        private Optional<String> includeZipcodes = Optional.empty();

        private Optional<String> excludeStates = Optional.empty();

        private Optional<String> preferCities = Optional.empty();

        private Optional<String> preferStates = Optional.empty();

        private Optional<String> preferZipcodes = Optional.empty();

        private Optional<Long> preferRatio = Optional.empty();

        private Optional<String> preferGeolocation = Optional.empty();

        private Optional<String> selected = Optional.empty();

        private Optional<String> source = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Partial or complete address to search.
         */
        public Builder search(String search) {
            Utils.checkNotNull(search, "search");
            this.search = search;
            return this;
        }


        /**
         * Maximum number of results to return.
         */
        public Builder maxResults(long maxResults) {
            Utils.checkNotNull(maxResults, "maxResults");
            this.maxResults = Optional.ofNullable(maxResults);
            return this;
        }

        /**
         * Maximum number of results to return.
         */
        public Builder maxResults(Optional<Long> maxResults) {
            Utils.checkNotNull(maxResults, "maxResults");
            this.maxResults = maxResults;
            return this;
        }


        /**
         * Limits results to a list of given cities.
         */
        public Builder includeCities(String includeCities) {
            Utils.checkNotNull(includeCities, "includeCities");
            this.includeCities = Optional.ofNullable(includeCities);
            return this;
        }

        /**
         * Limits results to a list of given cities.
         */
        public Builder includeCities(Optional<String> includeCities) {
            Utils.checkNotNull(includeCities, "includeCities");
            this.includeCities = includeCities;
            return this;
        }


        /**
         * Limits results to a list of given states.
         */
        public Builder includeStates(String includeStates) {
            Utils.checkNotNull(includeStates, "includeStates");
            this.includeStates = Optional.ofNullable(includeStates);
            return this;
        }

        /**
         * Limits results to a list of given states.
         */
        public Builder includeStates(Optional<String> includeStates) {
            Utils.checkNotNull(includeStates, "includeStates");
            this.includeStates = includeStates;
            return this;
        }


        /**
         * Limits results to a list of given zipcodes.
         */
        public Builder includeZipcodes(String includeZipcodes) {
            Utils.checkNotNull(includeZipcodes, "includeZipcodes");
            this.includeZipcodes = Optional.ofNullable(includeZipcodes);
            return this;
        }

        /**
         * Limits results to a list of given zipcodes.
         */
        public Builder includeZipcodes(Optional<String> includeZipcodes) {
            Utils.checkNotNull(includeZipcodes, "includeZipcodes");
            this.includeZipcodes = includeZipcodes;
            return this;
        }


        /**
         * Exclude list of states from results. No `include` pararmeters may be used with this parameter.
         */
        public Builder excludeStates(String excludeStates) {
            Utils.checkNotNull(excludeStates, "excludeStates");
            this.excludeStates = Optional.ofNullable(excludeStates);
            return this;
        }

        /**
         * Exclude list of states from results. No `include` pararmeters may be used with this parameter.
         */
        public Builder excludeStates(Optional<String> excludeStates) {
            Utils.checkNotNull(excludeStates, "excludeStates");
            this.excludeStates = excludeStates;
            return this;
        }


        /**
         * Display results with the listed cities at the top.
         */
        public Builder preferCities(String preferCities) {
            Utils.checkNotNull(preferCities, "preferCities");
            this.preferCities = Optional.ofNullable(preferCities);
            return this;
        }

        /**
         * Display results with the listed cities at the top.
         */
        public Builder preferCities(Optional<String> preferCities) {
            Utils.checkNotNull(preferCities, "preferCities");
            this.preferCities = preferCities;
            return this;
        }


        /**
         * Display results with the listed states at the top.
         */
        public Builder preferStates(String preferStates) {
            Utils.checkNotNull(preferStates, "preferStates");
            this.preferStates = Optional.ofNullable(preferStates);
            return this;
        }

        /**
         * Display results with the listed states at the top.
         */
        public Builder preferStates(Optional<String> preferStates) {
            Utils.checkNotNull(preferStates, "preferStates");
            this.preferStates = preferStates;
            return this;
        }


        /**
         * Display results with the listed zipcodes at the top.
         */
        public Builder preferZipcodes(String preferZipcodes) {
            Utils.checkNotNull(preferZipcodes, "preferZipcodes");
            this.preferZipcodes = Optional.ofNullable(preferZipcodes);
            return this;
        }

        /**
         * Display results with the listed zipcodes at the top.
         */
        public Builder preferZipcodes(Optional<String> preferZipcodes) {
            Utils.checkNotNull(preferZipcodes, "preferZipcodes");
            this.preferZipcodes = preferZipcodes;
            return this;
        }


        /**
         * Specifies the percentage of address suggestions that should be preferred and will appear at the top of the results.
         */
        public Builder preferRatio(long preferRatio) {
            Utils.checkNotNull(preferRatio, "preferRatio");
            this.preferRatio = Optional.ofNullable(preferRatio);
            return this;
        }

        /**
         * Specifies the percentage of address suggestions that should be preferred and will appear at the top of the results.
         */
        public Builder preferRatio(Optional<Long> preferRatio) {
            Utils.checkNotNull(preferRatio, "preferRatio");
            this.preferRatio = preferRatio;
            return this;
        }


        /**
         * If omitted or set to `city`, it uses the sender's IP address to determine location, then automatically adds the city and state 
         *   to the preferCities value. This parameter takes precedence over other `include` or `exclude` parameters meaning that if it is 
         *   not set to `none`, you may see addresses from areas you do not wish to see.
         */
        public Builder preferGeolocation(String preferGeolocation) {
            Utils.checkNotNull(preferGeolocation, "preferGeolocation");
            this.preferGeolocation = Optional.ofNullable(preferGeolocation);
            return this;
        }

        /**
         * If omitted or set to `city`, it uses the sender's IP address to determine location, then automatically adds the city and state 
         *   to the preferCities value. This parameter takes precedence over other `include` or `exclude` parameters meaning that if it is 
         *   not set to `none`, you may see addresses from areas you do not wish to see.
         */
        public Builder preferGeolocation(Optional<String> preferGeolocation) {
            Utils.checkNotNull(preferGeolocation, "preferGeolocation");
            this.preferGeolocation = preferGeolocation;
            return this;
        }


        /**
         * Useful for narrowing results with `addressLine2` suggestions such as `Apt` (denotes an apartment building with multiple residences).
         */
        public Builder selected(String selected) {
            Utils.checkNotNull(selected, "selected");
            this.selected = Optional.ofNullable(selected);
            return this;
        }

        /**
         * Useful for narrowing results with `addressLine2` suggestions such as `Apt` (denotes an apartment building with multiple residences).
         */
        public Builder selected(Optional<String> selected) {
            Utils.checkNotNull(selected, "selected");
            this.selected = selected;
            return this;
        }


        /**
         * Include results from alternate data sources. Allowed values are `all` (non-postal addresses), or `postal` (postal addresses only).
         */
        public Builder source(String source) {
            Utils.checkNotNull(source, "source");
            this.source = Optional.ofNullable(source);
            return this;
        }

        /**
         * Include results from alternate data sources. Allowed values are `all` (non-postal addresses), or `postal` (postal addresses only).
         */
        public Builder source(Optional<String> source) {
            Utils.checkNotNull(source, "source");
            this.source = source;
            return this;
        }

        public GetEnrichmentAddressRequest build() {

            return new GetEnrichmentAddressRequest(
                search, maxResults, includeCities,
                includeStates, includeZipcodes, excludeStates,
                preferCities, preferStates, preferZipcodes,
                preferRatio, preferGeolocation, selected,
                source);
        }

    }
}
