/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetDisputeEvidenceDataRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=disputeID")
    private String disputeID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=evidenceID")
    private String evidenceID;

    @JsonCreator
    public GetDisputeEvidenceDataRequest(
            String accountID,
            String disputeID,
            String evidenceID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(disputeID, "disputeID");
        Utils.checkNotNull(evidenceID, "evidenceID");
        this.accountID = accountID;
        this.disputeID = disputeID;
        this.evidenceID = evidenceID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String disputeID() {
        return disputeID;
    }

    @JsonIgnore
    public String evidenceID() {
        return evidenceID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public GetDisputeEvidenceDataRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public GetDisputeEvidenceDataRequest withDisputeID(String disputeID) {
        Utils.checkNotNull(disputeID, "disputeID");
        this.disputeID = disputeID;
        return this;
    }

    public GetDisputeEvidenceDataRequest withEvidenceID(String evidenceID) {
        Utils.checkNotNull(evidenceID, "evidenceID");
        this.evidenceID = evidenceID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetDisputeEvidenceDataRequest other = (GetDisputeEvidenceDataRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.disputeID, other.disputeID) &&
            Utils.enhancedDeepEquals(this.evidenceID, other.evidenceID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, disputeID, evidenceID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetDisputeEvidenceDataRequest.class,
                "accountID", accountID,
                "disputeID", disputeID,
                "evidenceID", evidenceID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String disputeID;

        private String evidenceID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder disputeID(String disputeID) {
            Utils.checkNotNull(disputeID, "disputeID");
            this.disputeID = disputeID;
            return this;
        }


        public Builder evidenceID(String evidenceID) {
            Utils.checkNotNull(evidenceID, "evidenceID");
            this.evidenceID = evidenceID;
            return this;
        }

        public GetDisputeEvidenceDataRequest build() {

            return new GetDisputeEvidenceDataRequest(
                accountID, disputeID, evidenceID);
        }

    }
}
