/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CapabilityID;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetCapabilityRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * Moov account capabilities.
     * 
     * <p>The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=capabilityID")
    private CapabilityID capabilityID;

    @JsonCreator
    public GetCapabilityRequest(
            String accountID,
            CapabilityID capabilityID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(capabilityID, "capabilityID");
        this.accountID = accountID;
        this.capabilityID = capabilityID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * Moov account capabilities.
     * 
     * <p>The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
     */
    @JsonIgnore
    public CapabilityID capabilityID() {
        return capabilityID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public GetCapabilityRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * Moov account capabilities.
     * 
     * <p>The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
     */
    public GetCapabilityRequest withCapabilityID(CapabilityID capabilityID) {
        Utils.checkNotNull(capabilityID, "capabilityID");
        this.capabilityID = capabilityID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetCapabilityRequest other = (GetCapabilityRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.capabilityID, other.capabilityID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, capabilityID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetCapabilityRequest.class,
                "accountID", accountID,
                "capabilityID", capabilityID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private CapabilityID capabilityID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * Moov account capabilities.
         * 
         * <p>The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
         */
        public Builder capabilityID(CapabilityID capabilityID) {
            Utils.checkNotNull(capabilityID, "capabilityID");
            this.capabilityID = capabilityID;
            return this;
        }

        public GetCapabilityRequest build() {

            return new GetCapabilityRequest(
                accountID, capabilityID);
        }

    }
}
