/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetCancellationRequest {
    /**
     * Moov account ID of the partner or transfer's source or destination.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * Identifier for the transfer.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=transferID")
    private String transferID;

    /**
     * Identifier for the cancellation.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=cancellationID")
    private String cancellationID;

    @JsonCreator
    public GetCancellationRequest(
            String accountID,
            String transferID,
            String cancellationID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(cancellationID, "cancellationID");
        this.accountID = accountID;
        this.transferID = transferID;
        this.cancellationID = cancellationID;
    }

    /**
     * Moov account ID of the partner or transfer's source or destination.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * Identifier for the transfer.
     */
    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    /**
     * Identifier for the cancellation.
     */
    @JsonIgnore
    public String cancellationID() {
        return cancellationID;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Moov account ID of the partner or transfer's source or destination.
     */
    public GetCancellationRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * Identifier for the transfer.
     */
    public GetCancellationRequest withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    /**
     * Identifier for the cancellation.
     */
    public GetCancellationRequest withCancellationID(String cancellationID) {
        Utils.checkNotNull(cancellationID, "cancellationID");
        this.cancellationID = cancellationID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetCancellationRequest other = (GetCancellationRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.transferID, other.transferID) &&
            Utils.enhancedDeepEquals(this.cancellationID, other.cancellationID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, transferID, cancellationID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetCancellationRequest.class,
                "accountID", accountID,
                "transferID", transferID,
                "cancellationID", cancellationID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String transferID;

        private String cancellationID;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Moov account ID of the partner or transfer's source or destination.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * Identifier for the transfer.
         */
        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }


        /**
         * Identifier for the cancellation.
         */
        public Builder cancellationID(String cancellationID) {
            Utils.checkNotNull(cancellationID, "cancellationID");
            this.cancellationID = cancellationID;
            return this;
        }

        public GetCancellationRequest build() {

            return new GetCancellationRequest(
                accountID, transferID, cancellationID);
        }

    }
}
