/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetBankAccountVerificationRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=bankAccountID")
    private String bankAccountID;

    @JsonCreator
    public GetBankAccountVerificationRequest(
            String accountID,
            String bankAccountID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(bankAccountID, "bankAccountID");
        this.accountID = accountID;
        this.bankAccountID = bankAccountID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String bankAccountID() {
        return bankAccountID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public GetBankAccountVerificationRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public GetBankAccountVerificationRequest withBankAccountID(String bankAccountID) {
        Utils.checkNotNull(bankAccountID, "bankAccountID");
        this.bankAccountID = bankAccountID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetBankAccountVerificationRequest other = (GetBankAccountVerificationRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.bankAccountID, other.bankAccountID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, bankAccountID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetBankAccountVerificationRequest.class,
                "accountID", accountID,
                "bankAccountID", bankAccountID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String bankAccountID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder bankAccountID(String bankAccountID) {
            Utils.checkNotNull(bankAccountID, "bankAccountID");
            this.bankAccountID = bankAccountID;
            return this;
        }

        public GetBankAccountVerificationRequest build() {

            return new GetBankAccountVerificationRequest(
                accountID, bankAccountID);
        }

    }
}
