/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetAdjustmentRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=adjustmentID")
    private String adjustmentID;

    @JsonCreator
    public GetAdjustmentRequest(
            String accountID,
            String adjustmentID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(adjustmentID, "adjustmentID");
        this.accountID = accountID;
        this.adjustmentID = adjustmentID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String adjustmentID() {
        return adjustmentID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public GetAdjustmentRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public GetAdjustmentRequest withAdjustmentID(String adjustmentID) {
        Utils.checkNotNull(adjustmentID, "adjustmentID");
        this.adjustmentID = adjustmentID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetAdjustmentRequest other = (GetAdjustmentRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.adjustmentID, other.adjustmentID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, adjustmentID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetAdjustmentRequest.class,
                "accountID", accountID,
                "adjustmentID", adjustmentID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String adjustmentID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder adjustmentID(String adjustmentID) {
            Utils.checkNotNull(adjustmentID, "adjustmentID");
            this.adjustmentID = adjustmentID;
            return this;
        }

        public GetAdjustmentRequest build() {

            return new GetAdjustmentRequest(
                accountID, adjustmentID);
        }

    }
}
