/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class DisablePaymentLinkRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=paymentLinkCode")
    private String paymentLinkCode;

    @JsonCreator
    public DisablePaymentLinkRequest(
            String accountID,
            String paymentLinkCode) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(paymentLinkCode, "paymentLinkCode");
        this.accountID = accountID;
        this.paymentLinkCode = paymentLinkCode;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String paymentLinkCode() {
        return paymentLinkCode;
    }

    public static Builder builder() {
        return new Builder();
    }


    public DisablePaymentLinkRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public DisablePaymentLinkRequest withPaymentLinkCode(String paymentLinkCode) {
        Utils.checkNotNull(paymentLinkCode, "paymentLinkCode");
        this.paymentLinkCode = paymentLinkCode;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DisablePaymentLinkRequest other = (DisablePaymentLinkRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.paymentLinkCode, other.paymentLinkCode);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, paymentLinkCode);
    }
    
    @Override
    public String toString() {
        return Utils.toString(DisablePaymentLinkRequest.class,
                "accountID", accountID,
                "paymentLinkCode", paymentLinkCode);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String paymentLinkCode;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder paymentLinkCode(String paymentLinkCode) {
            Utils.checkNotNull(paymentLinkCode, "paymentLinkCode");
            this.paymentLinkCode = paymentLinkCode;
            return this;
        }

        public DisablePaymentLinkRequest build() {

            return new DisablePaymentLinkRequest(
                accountID, paymentLinkCode);
        }

    }
}
