/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class DisableCardRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=cardID")
    private String cardID;

    @JsonCreator
    public DisableCardRequest(
            String accountID,
            String cardID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(cardID, "cardID");
        this.accountID = accountID;
        this.cardID = cardID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String cardID() {
        return cardID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public DisableCardRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public DisableCardRequest withCardID(String cardID) {
        Utils.checkNotNull(cardID, "cardID");
        this.cardID = cardID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DisableCardRequest other = (DisableCardRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.cardID, other.cardID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, cardID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(DisableCardRequest.class,
                "accountID", accountID,
                "cardID", cardID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String cardID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder cardID(String cardID) {
            Utils.checkNotNull(cardID, "cardID");
            this.cardID = cardID;
            return this;
        }

        public DisableCardRequest build() {

            return new DisableCardRequest(
                accountID, cardID);
        }

    }
}
