/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CreateTransfer;
import io.moov.sdk.models.components.TransferWaitFor;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class CreateTransferRequest {
    /**
     * Prevents duplicate transfers from being created.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-idempotency-key")
    private String xIdempotencyKey;

    /**
     * Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an 
     * asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-wait-for")
    private Optional<? extends TransferWaitFor> xWaitFor;

    /**
     * Your Moov account ID.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private CreateTransfer createTransfer;

    @JsonCreator
    public CreateTransferRequest(
            String xIdempotencyKey,
            Optional<? extends TransferWaitFor> xWaitFor,
            String accountID,
            CreateTransfer createTransfer) {
        Utils.checkNotNull(xIdempotencyKey, "xIdempotencyKey");
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(createTransfer, "createTransfer");
        this.xIdempotencyKey = xIdempotencyKey;
        this.xWaitFor = xWaitFor;
        this.accountID = accountID;
        this.createTransfer = createTransfer;
    }
    
    public CreateTransferRequest(
            String xIdempotencyKey,
            String accountID,
            CreateTransfer createTransfer) {
        this(xIdempotencyKey, Optional.empty(), accountID,
            createTransfer);
    }

    /**
     * Prevents duplicate transfers from being created.
     */
    @JsonIgnore
    public String xIdempotencyKey() {
        return xIdempotencyKey;
    }

    /**
     * Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an 
     * asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<TransferWaitFor> xWaitFor() {
        return (Optional<TransferWaitFor>) xWaitFor;
    }

    /**
     * Your Moov account ID.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public CreateTransfer createTransfer() {
        return createTransfer;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Prevents duplicate transfers from being created.
     */
    public CreateTransferRequest withXIdempotencyKey(String xIdempotencyKey) {
        Utils.checkNotNull(xIdempotencyKey, "xIdempotencyKey");
        this.xIdempotencyKey = xIdempotencyKey;
        return this;
    }

    /**
     * Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an 
     * asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
     */
    public CreateTransferRequest withXWaitFor(TransferWaitFor xWaitFor) {
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        this.xWaitFor = Optional.ofNullable(xWaitFor);
        return this;
    }


    /**
     * Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an 
     * asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
     */
    public CreateTransferRequest withXWaitFor(Optional<? extends TransferWaitFor> xWaitFor) {
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        this.xWaitFor = xWaitFor;
        return this;
    }

    /**
     * Your Moov account ID.
     */
    public CreateTransferRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public CreateTransferRequest withCreateTransfer(CreateTransfer createTransfer) {
        Utils.checkNotNull(createTransfer, "createTransfer");
        this.createTransfer = createTransfer;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTransferRequest other = (CreateTransferRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xIdempotencyKey, other.xIdempotencyKey) &&
            Utils.enhancedDeepEquals(this.xWaitFor, other.xWaitFor) &&
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.createTransfer, other.createTransfer);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xIdempotencyKey, xWaitFor, accountID,
            createTransfer);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTransferRequest.class,
                "xIdempotencyKey", xIdempotencyKey,
                "xWaitFor", xWaitFor,
                "accountID", accountID,
                "createTransfer", createTransfer);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xIdempotencyKey;

        private Optional<? extends TransferWaitFor> xWaitFor = Optional.empty();

        private String accountID;

        private CreateTransfer createTransfer;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Prevents duplicate transfers from being created.
         */
        public Builder xIdempotencyKey(String xIdempotencyKey) {
            Utils.checkNotNull(xIdempotencyKey, "xIdempotencyKey");
            this.xIdempotencyKey = xIdempotencyKey;
            return this;
        }


        /**
         * Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an 
         * asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
         */
        public Builder xWaitFor(TransferWaitFor xWaitFor) {
            Utils.checkNotNull(xWaitFor, "xWaitFor");
            this.xWaitFor = Optional.ofNullable(xWaitFor);
            return this;
        }

        /**
         * Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an 
         * asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
         */
        public Builder xWaitFor(Optional<? extends TransferWaitFor> xWaitFor) {
            Utils.checkNotNull(xWaitFor, "xWaitFor");
            this.xWaitFor = xWaitFor;
            return this;
        }


        /**
         * Your Moov account ID.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder createTransfer(CreateTransfer createTransfer) {
            Utils.checkNotNull(createTransfer, "createTransfer");
            this.createTransfer = createTransfer;
            return this;
        }

        public CreateTransferRequest build() {

            return new CreateTransferRequest(
                xIdempotencyKey, xWaitFor, accountID,
                createTransfer);
        }

    }
}
