/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CreateTransferOptions;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class CreateTransferOptionsRequest {
    /**
     * The partner's Moov account ID.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private CreateTransferOptions createTransferOptions;

    @JsonCreator
    public CreateTransferOptionsRequest(
            String accountID,
            CreateTransferOptions createTransferOptions) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(createTransferOptions, "createTransferOptions");
        this.accountID = accountID;
        this.createTransferOptions = createTransferOptions;
    }

    /**
     * The partner's Moov account ID.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public CreateTransferOptions createTransferOptions() {
        return createTransferOptions;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The partner's Moov account ID.
     */
    public CreateTransferOptionsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public CreateTransferOptionsRequest withCreateTransferOptions(CreateTransferOptions createTransferOptions) {
        Utils.checkNotNull(createTransferOptions, "createTransferOptions");
        this.createTransferOptions = createTransferOptions;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTransferOptionsRequest other = (CreateTransferOptionsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.createTransferOptions, other.createTransferOptions);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, createTransferOptions);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTransferOptionsRequest.class,
                "accountID", accountID,
                "createTransferOptions", createTransferOptions);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private CreateTransferOptions createTransferOptions;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The partner's Moov account ID.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder createTransferOptions(CreateTransferOptions createTransferOptions) {
            Utils.checkNotNull(createTransferOptions, "createTransferOptions");
            this.createTransferOptions = createTransferOptions;
            return this;
        }

        public CreateTransferOptionsRequest build() {

            return new CreateTransferOptionsRequest(
                accountID, createTransferOptions);
        }

    }
}
