/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CreateTicket;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class CreateTicketRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private CreateTicket createTicket;

    @JsonCreator
    public CreateTicketRequest(
            String accountID,
            CreateTicket createTicket) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(createTicket, "createTicket");
        this.accountID = accountID;
        this.createTicket = createTicket;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public CreateTicket createTicket() {
        return createTicket;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreateTicketRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public CreateTicketRequest withCreateTicket(CreateTicket createTicket) {
        Utils.checkNotNull(createTicket, "createTicket");
        this.createTicket = createTicket;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTicketRequest other = (CreateTicketRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.createTicket, other.createTicket);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, createTicket);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTicketRequest.class,
                "accountID", accountID,
                "createTicket", createTicket);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private CreateTicket createTicket;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder createTicket(CreateTicket createTicket) {
            Utils.checkNotNull(createTicket, "createTicket");
            this.createTicket = createTicket;
            return this;
        }

        public CreateTicketRequest build() {

            return new CreateTicketRequest(
                accountID, createTicket);
        }

    }
}
