/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.TerminalApplicationVersion;
import io.moov.sdk.utils.Response;
import io.moov.sdk.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class CreateTerminalApplicationVersionResponse implements Response {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The request completed successfully.
     */
    private Optional<? extends TerminalApplicationVersion> terminalApplicationVersion;


    private Map<String, List<String>> headers;

    @JsonCreator
    public CreateTerminalApplicationVersionResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends TerminalApplicationVersion> terminalApplicationVersion,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(terminalApplicationVersion, "terminalApplicationVersion");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.terminalApplicationVersion = terminalApplicationVersion;
        this.headers = headers;
    }
    
    public CreateTerminalApplicationVersionResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The request completed successfully.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<TerminalApplicationVersion> terminalApplicationVersion() {
        return (Optional<TerminalApplicationVersion>) terminalApplicationVersion;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public CreateTerminalApplicationVersionResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public CreateTerminalApplicationVersionResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public CreateTerminalApplicationVersionResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The request completed successfully.
     */
    public CreateTerminalApplicationVersionResponse withTerminalApplicationVersion(TerminalApplicationVersion terminalApplicationVersion) {
        Utils.checkNotNull(terminalApplicationVersion, "terminalApplicationVersion");
        this.terminalApplicationVersion = Optional.ofNullable(terminalApplicationVersion);
        return this;
    }


    /**
     * The request completed successfully.
     */
    public CreateTerminalApplicationVersionResponse withTerminalApplicationVersion(Optional<? extends TerminalApplicationVersion> terminalApplicationVersion) {
        Utils.checkNotNull(terminalApplicationVersion, "terminalApplicationVersion");
        this.terminalApplicationVersion = terminalApplicationVersion;
        return this;
    }

    public CreateTerminalApplicationVersionResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTerminalApplicationVersionResponse other = (CreateTerminalApplicationVersionResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.terminalApplicationVersion, other.terminalApplicationVersion) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            terminalApplicationVersion, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTerminalApplicationVersionResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "terminalApplicationVersion", terminalApplicationVersion,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<InputStream> rawResponse;

        private Optional<? extends TerminalApplicationVersion> terminalApplicationVersion = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The request completed successfully.
         */
        public Builder terminalApplicationVersion(TerminalApplicationVersion terminalApplicationVersion) {
            Utils.checkNotNull(terminalApplicationVersion, "terminalApplicationVersion");
            this.terminalApplicationVersion = Optional.ofNullable(terminalApplicationVersion);
            return this;
        }

        /**
         * The request completed successfully.
         */
        public Builder terminalApplicationVersion(Optional<? extends TerminalApplicationVersion> terminalApplicationVersion) {
            Utils.checkNotNull(terminalApplicationVersion, "terminalApplicationVersion");
            this.terminalApplicationVersion = terminalApplicationVersion;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public CreateTerminalApplicationVersionResponse build() {

            return new CreateTerminalApplicationVersionResponse(
                contentType, statusCode, rawResponse,
                terminalApplicationVersion, headers);
        }

    }
}
