/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.TerminalApplicationVersion;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class CreateTerminalApplicationVersionRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=terminalApplicationID")
    private String terminalApplicationID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private TerminalApplicationVersion terminalApplicationVersion;

    @JsonCreator
    public CreateTerminalApplicationVersionRequest(
            String terminalApplicationID,
            TerminalApplicationVersion terminalApplicationVersion) {
        Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
        Utils.checkNotNull(terminalApplicationVersion, "terminalApplicationVersion");
        this.terminalApplicationID = terminalApplicationID;
        this.terminalApplicationVersion = terminalApplicationVersion;
    }

    @JsonIgnore
    public String terminalApplicationID() {
        return terminalApplicationID;
    }

    @JsonIgnore
    public TerminalApplicationVersion terminalApplicationVersion() {
        return terminalApplicationVersion;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreateTerminalApplicationVersionRequest withTerminalApplicationID(String terminalApplicationID) {
        Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
        this.terminalApplicationID = terminalApplicationID;
        return this;
    }

    public CreateTerminalApplicationVersionRequest withTerminalApplicationVersion(TerminalApplicationVersion terminalApplicationVersion) {
        Utils.checkNotNull(terminalApplicationVersion, "terminalApplicationVersion");
        this.terminalApplicationVersion = terminalApplicationVersion;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTerminalApplicationVersionRequest other = (CreateTerminalApplicationVersionRequest) o;
        return 
            Utils.enhancedDeepEquals(this.terminalApplicationID, other.terminalApplicationID) &&
            Utils.enhancedDeepEquals(this.terminalApplicationVersion, other.terminalApplicationVersion);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            terminalApplicationID, terminalApplicationVersion);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTerminalApplicationVersionRequest.class,
                "terminalApplicationID", terminalApplicationID,
                "terminalApplicationVersion", terminalApplicationVersion);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String terminalApplicationID;

        private TerminalApplicationVersion terminalApplicationVersion;

        private Builder() {
          // force use of static builder() method
        }


        public Builder terminalApplicationID(String terminalApplicationID) {
            Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
            this.terminalApplicationID = terminalApplicationID;
            return this;
        }


        public Builder terminalApplicationVersion(TerminalApplicationVersion terminalApplicationVersion) {
            Utils.checkNotNull(terminalApplicationVersion, "terminalApplicationVersion");
            this.terminalApplicationVersion = terminalApplicationVersion;
            return this;
        }

        public CreateTerminalApplicationVersionRequest build() {

            return new CreateTerminalApplicationVersionRequest(
                terminalApplicationID, terminalApplicationVersion);
        }

    }
}
