/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CreateSweepConfig;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class CreateSweepConfigRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private CreateSweepConfig createSweepConfig;

    @JsonCreator
    public CreateSweepConfigRequest(
            String accountID,
            CreateSweepConfig createSweepConfig) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(createSweepConfig, "createSweepConfig");
        this.accountID = accountID;
        this.createSweepConfig = createSweepConfig;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public CreateSweepConfig createSweepConfig() {
        return createSweepConfig;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreateSweepConfigRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public CreateSweepConfigRequest withCreateSweepConfig(CreateSweepConfig createSweepConfig) {
        Utils.checkNotNull(createSweepConfig, "createSweepConfig");
        this.createSweepConfig = createSweepConfig;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateSweepConfigRequest other = (CreateSweepConfigRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.createSweepConfig, other.createSweepConfig);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, createSweepConfig);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateSweepConfigRequest.class,
                "accountID", accountID,
                "createSweepConfig", createSweepConfig);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private CreateSweepConfig createSweepConfig;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder createSweepConfig(CreateSweepConfig createSweepConfig) {
            Utils.checkNotNull(createSweepConfig, "createSweepConfig");
            this.createSweepConfig = createSweepConfig;
            return this;
        }

        public CreateSweepConfigRequest build() {

            return new CreateSweepConfigRequest(
                accountID, createSweepConfig);
        }

    }
}
