/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.UpsertSchedule;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class CreateScheduleRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UpsertSchedule upsertSchedule;

    @JsonCreator
    public CreateScheduleRequest(
            String accountID,
            UpsertSchedule upsertSchedule) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(upsertSchedule, "upsertSchedule");
        this.accountID = accountID;
        this.upsertSchedule = upsertSchedule;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public UpsertSchedule upsertSchedule() {
        return upsertSchedule;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreateScheduleRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public CreateScheduleRequest withUpsertSchedule(UpsertSchedule upsertSchedule) {
        Utils.checkNotNull(upsertSchedule, "upsertSchedule");
        this.upsertSchedule = upsertSchedule;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateScheduleRequest other = (CreateScheduleRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.upsertSchedule, other.upsertSchedule);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, upsertSchedule);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateScheduleRequest.class,
                "accountID", accountID,
                "upsertSchedule", upsertSchedule);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private UpsertSchedule upsertSchedule;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder upsertSchedule(UpsertSchedule upsertSchedule) {
            Utils.checkNotNull(upsertSchedule, "upsertSchedule");
            this.upsertSchedule = upsertSchedule;
            return this;
        }

        public CreateScheduleRequest build() {

            return new CreateScheduleRequest(
                accountID, upsertSchedule);
        }

    }
}
