/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CreateRepresentative;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class CreateRepresentativeRequest {
    /**
     * ID of the account.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private CreateRepresentative createRepresentative;

    @JsonCreator
    public CreateRepresentativeRequest(
            String accountID,
            CreateRepresentative createRepresentative) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(createRepresentative, "createRepresentative");
        this.accountID = accountID;
        this.createRepresentative = createRepresentative;
    }

    /**
     * ID of the account.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public CreateRepresentative createRepresentative() {
        return createRepresentative;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * ID of the account.
     */
    public CreateRepresentativeRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public CreateRepresentativeRequest withCreateRepresentative(CreateRepresentative createRepresentative) {
        Utils.checkNotNull(createRepresentative, "createRepresentative");
        this.createRepresentative = createRepresentative;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateRepresentativeRequest other = (CreateRepresentativeRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.createRepresentative, other.createRepresentative);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, createRepresentative);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateRepresentativeRequest.class,
                "accountID", accountID,
                "createRepresentative", createRepresentative);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private CreateRepresentative createRepresentative;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * ID of the account.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder createRepresentative(CreateRepresentative createRepresentative) {
            Utils.checkNotNull(createRepresentative, "createRepresentative");
            this.createRepresentative = createRepresentative;
            return this;
        }

        public CreateRepresentativeRequest build() {

            return new CreateRepresentativeRequest(
                accountID, createRepresentative);
        }

    }
}
