/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CreatePaymentLink;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class CreatePaymentLinkRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private CreatePaymentLink createPaymentLink;

    @JsonCreator
    public CreatePaymentLinkRequest(
            String accountID,
            CreatePaymentLink createPaymentLink) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(createPaymentLink, "createPaymentLink");
        this.accountID = accountID;
        this.createPaymentLink = createPaymentLink;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public CreatePaymentLink createPaymentLink() {
        return createPaymentLink;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreatePaymentLinkRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public CreatePaymentLinkRequest withCreatePaymentLink(CreatePaymentLink createPaymentLink) {
        Utils.checkNotNull(createPaymentLink, "createPaymentLink");
        this.createPaymentLink = createPaymentLink;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreatePaymentLinkRequest other = (CreatePaymentLinkRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.createPaymentLink, other.createPaymentLink);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, createPaymentLink);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreatePaymentLinkRequest.class,
                "accountID", accountID,
                "createPaymentLink", createPaymentLink);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private CreatePaymentLink createPaymentLink;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder createPaymentLink(CreatePaymentLink createPaymentLink) {
            Utils.checkNotNull(createPaymentLink, "createPaymentLink");
            this.createPaymentLink = createPaymentLink;
            return this;
        }

        public CreatePaymentLinkRequest build() {

            return new CreatePaymentLinkRequest(
                accountID, createPaymentLink);
        }

    }
}
