/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CreateFeePlanAgreement;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class CreateFeePlanAgreementsRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private CreateFeePlanAgreement createFeePlanAgreement;

    @JsonCreator
    public CreateFeePlanAgreementsRequest(
            String accountID,
            CreateFeePlanAgreement createFeePlanAgreement) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(createFeePlanAgreement, "createFeePlanAgreement");
        this.accountID = accountID;
        this.createFeePlanAgreement = createFeePlanAgreement;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public CreateFeePlanAgreement createFeePlanAgreement() {
        return createFeePlanAgreement;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreateFeePlanAgreementsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public CreateFeePlanAgreementsRequest withCreateFeePlanAgreement(CreateFeePlanAgreement createFeePlanAgreement) {
        Utils.checkNotNull(createFeePlanAgreement, "createFeePlanAgreement");
        this.createFeePlanAgreement = createFeePlanAgreement;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateFeePlanAgreementsRequest other = (CreateFeePlanAgreementsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.createFeePlanAgreement, other.createFeePlanAgreement);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, createFeePlanAgreement);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateFeePlanAgreementsRequest.class,
                "accountID", accountID,
                "createFeePlanAgreement", createFeePlanAgreement);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private CreateFeePlanAgreement createFeePlanAgreement;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder createFeePlanAgreement(CreateFeePlanAgreement createFeePlanAgreement) {
            Utils.checkNotNull(createFeePlanAgreement, "createFeePlanAgreement");
            this.createFeePlanAgreement = createFeePlanAgreement;
            return this;
        }

        public CreateFeePlanAgreementsRequest build() {

            return new CreateFeePlanAgreementsRequest(
                accountID, createFeePlanAgreement);
        }

    }
}
