/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CreateApplePaySession;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class CreateApplePaySessionRequest {
    /**
     * ID of the Moov account representing the merchant.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private CreateApplePaySession createApplePaySession;

    @JsonCreator
    public CreateApplePaySessionRequest(
            String accountID,
            CreateApplePaySession createApplePaySession) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(createApplePaySession, "createApplePaySession");
        this.accountID = accountID;
        this.createApplePaySession = createApplePaySession;
    }

    /**
     * ID of the Moov account representing the merchant.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public CreateApplePaySession createApplePaySession() {
        return createApplePaySession;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * ID of the Moov account representing the merchant.
     */
    public CreateApplePaySessionRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public CreateApplePaySessionRequest withCreateApplePaySession(CreateApplePaySession createApplePaySession) {
        Utils.checkNotNull(createApplePaySession, "createApplePaySession");
        this.createApplePaySession = createApplePaySession;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateApplePaySessionRequest other = (CreateApplePaySessionRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.createApplePaySession, other.createApplePaySession);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, createApplePaySession);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateApplePaySessionRequest.class,
                "accountID", accountID,
                "createApplePaySession", createApplePaySession);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private CreateApplePaySession createApplePaySession;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * ID of the Moov account representing the merchant.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder createApplePaySession(CreateApplePaySession createApplePaySession) {
            Utils.checkNotNull(createApplePaySession, "createApplePaySession");
            this.createApplePaySession = createApplePaySession;
            return this;
        }

        public CreateApplePaySessionRequest build() {

            return new CreateApplePaySessionRequest(
                accountID, createApplePaySession);
        }

    }
}
