/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CompleteMicroDeposits;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class CompleteMicroDepositsRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=bankAccountID")
    private String bankAccountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private CompleteMicroDeposits completeMicroDeposits;

    @JsonCreator
    public CompleteMicroDepositsRequest(
            String accountID,
            String bankAccountID,
            CompleteMicroDeposits completeMicroDeposits) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(bankAccountID, "bankAccountID");
        Utils.checkNotNull(completeMicroDeposits, "completeMicroDeposits");
        this.accountID = accountID;
        this.bankAccountID = bankAccountID;
        this.completeMicroDeposits = completeMicroDeposits;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String bankAccountID() {
        return bankAccountID;
    }

    @JsonIgnore
    public CompleteMicroDeposits completeMicroDeposits() {
        return completeMicroDeposits;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CompleteMicroDepositsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public CompleteMicroDepositsRequest withBankAccountID(String bankAccountID) {
        Utils.checkNotNull(bankAccountID, "bankAccountID");
        this.bankAccountID = bankAccountID;
        return this;
    }

    public CompleteMicroDepositsRequest withCompleteMicroDeposits(CompleteMicroDeposits completeMicroDeposits) {
        Utils.checkNotNull(completeMicroDeposits, "completeMicroDeposits");
        this.completeMicroDeposits = completeMicroDeposits;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CompleteMicroDepositsRequest other = (CompleteMicroDepositsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.bankAccountID, other.bankAccountID) &&
            Utils.enhancedDeepEquals(this.completeMicroDeposits, other.completeMicroDeposits);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, bankAccountID, completeMicroDeposits);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CompleteMicroDepositsRequest.class,
                "accountID", accountID,
                "bankAccountID", bankAccountID,
                "completeMicroDeposits", completeMicroDeposits);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String bankAccountID;

        private CompleteMicroDeposits completeMicroDeposits;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder bankAccountID(String bankAccountID) {
            Utils.checkNotNull(bankAccountID, "bankAccountID");
            this.bankAccountID = bankAccountID;
            return this;
        }


        public Builder completeMicroDeposits(CompleteMicroDeposits completeMicroDeposits) {
            Utils.checkNotNull(completeMicroDeposits, "completeMicroDeposits");
            this.completeMicroDeposits = completeMicroDeposits;
            return this;
        }

        public CompleteMicroDepositsRequest build() {

            return new CompleteMicroDepositsRequest(
                accountID, bankAccountID, completeMicroDeposits);
        }

    }
}
