/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.SDKConfiguration;
import io.moov.sdk.models.components.CompleteBankAccountVerification;
import io.moov.sdk.operations.CompleteBankAccountVerificationOperation;
import io.moov.sdk.utils.Utils;
import java.lang.Exception;
import java.lang.String;

public class CompleteBankAccountVerificationRequestBuilder {

    private String accountID;
    private String bankAccountID;
    private CompleteBankAccountVerification completeBankAccountVerification;
    private final SDKConfiguration sdkConfiguration;

    public CompleteBankAccountVerificationRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CompleteBankAccountVerificationRequestBuilder accountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public CompleteBankAccountVerificationRequestBuilder bankAccountID(String bankAccountID) {
        Utils.checkNotNull(bankAccountID, "bankAccountID");
        this.bankAccountID = bankAccountID;
        return this;
    }

    public CompleteBankAccountVerificationRequestBuilder completeBankAccountVerification(CompleteBankAccountVerification completeBankAccountVerification) {
        Utils.checkNotNull(completeBankAccountVerification, "completeBankAccountVerification");
        this.completeBankAccountVerification = completeBankAccountVerification;
        return this;
    }


    private CompleteBankAccountVerificationRequest buildRequest() {

        CompleteBankAccountVerificationRequest request = new CompleteBankAccountVerificationRequest(accountID,
            bankAccountID,
            completeBankAccountVerification);

        return request;
    }

    public CompleteBankAccountVerificationResponse call() throws Exception {
        
        RequestOperation<CompleteBankAccountVerificationRequest, CompleteBankAccountVerificationResponse> operation
              = new CompleteBankAccountVerificationOperation(sdkConfiguration);
        CompleteBankAccountVerificationRequest request = buildRequest();

        return operation.handleResponse(operation.doRequest(request));
    }
}
