/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CompleteBankAccountVerification;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class CompleteBankAccountVerificationRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=bankAccountID")
    private String bankAccountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private CompleteBankAccountVerification completeBankAccountVerification;

    @JsonCreator
    public CompleteBankAccountVerificationRequest(
            String accountID,
            String bankAccountID,
            CompleteBankAccountVerification completeBankAccountVerification) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(bankAccountID, "bankAccountID");
        Utils.checkNotNull(completeBankAccountVerification, "completeBankAccountVerification");
        this.accountID = accountID;
        this.bankAccountID = bankAccountID;
        this.completeBankAccountVerification = completeBankAccountVerification;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String bankAccountID() {
        return bankAccountID;
    }

    @JsonIgnore
    public CompleteBankAccountVerification completeBankAccountVerification() {
        return completeBankAccountVerification;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CompleteBankAccountVerificationRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public CompleteBankAccountVerificationRequest withBankAccountID(String bankAccountID) {
        Utils.checkNotNull(bankAccountID, "bankAccountID");
        this.bankAccountID = bankAccountID;
        return this;
    }

    public CompleteBankAccountVerificationRequest withCompleteBankAccountVerification(CompleteBankAccountVerification completeBankAccountVerification) {
        Utils.checkNotNull(completeBankAccountVerification, "completeBankAccountVerification");
        this.completeBankAccountVerification = completeBankAccountVerification;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CompleteBankAccountVerificationRequest other = (CompleteBankAccountVerificationRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.bankAccountID, other.bankAccountID) &&
            Utils.enhancedDeepEquals(this.completeBankAccountVerification, other.completeBankAccountVerification);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, bankAccountID, completeBankAccountVerification);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CompleteBankAccountVerificationRequest.class,
                "accountID", accountID,
                "bankAccountID", bankAccountID,
                "completeBankAccountVerification", completeBankAccountVerification);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String bankAccountID;

        private CompleteBankAccountVerification completeBankAccountVerification;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder bankAccountID(String bankAccountID) {
            Utils.checkNotNull(bankAccountID, "bankAccountID");
            this.bankAccountID = bankAccountID;
            return this;
        }


        public Builder completeBankAccountVerification(CompleteBankAccountVerification completeBankAccountVerification) {
            Utils.checkNotNull(completeBankAccountVerification, "completeBankAccountVerification");
            this.completeBankAccountVerification = completeBankAccountVerification;
            return this;
        }

        public CompleteBankAccountVerificationRequest build() {

            return new CompleteBankAccountVerificationRequest(
                accountID, bankAccountID, completeBankAccountVerification);
        }

    }
}
