/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.AccountCountries;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class AssignAccountCountriesRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private AccountCountries accountCountries;

    @JsonCreator
    public AssignAccountCountriesRequest(
            String accountID,
            AccountCountries accountCountries) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(accountCountries, "accountCountries");
        this.accountID = accountID;
        this.accountCountries = accountCountries;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public AccountCountries accountCountries() {
        return accountCountries;
    }

    public static Builder builder() {
        return new Builder();
    }


    public AssignAccountCountriesRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public AssignAccountCountriesRequest withAccountCountries(AccountCountries accountCountries) {
        Utils.checkNotNull(accountCountries, "accountCountries");
        this.accountCountries = accountCountries;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AssignAccountCountriesRequest other = (AssignAccountCountriesRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.accountCountries, other.accountCountries);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, accountCountries);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AssignAccountCountriesRequest.class,
                "accountID", accountID,
                "accountCountries", accountCountries);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private AccountCountries accountCountries;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder accountCountries(AccountCountries accountCountries) {
            Utils.checkNotNull(accountCountries, "accountCountries");
            this.accountCountries = accountCountries;
            return this;
        }

        public AssignAccountCountriesRequest build() {

            return new AssignAccountCountriesRequest(
                accountID, accountCountries);
        }

    }
}
