/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class AcceptDisputeRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=disputeID")
    private String disputeID;

    @JsonCreator
    public AcceptDisputeRequest(
            String accountID,
            String disputeID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(disputeID, "disputeID");
        this.accountID = accountID;
        this.disputeID = disputeID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String disputeID() {
        return disputeID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public AcceptDisputeRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public AcceptDisputeRequest withDisputeID(String disputeID) {
        Utils.checkNotNull(disputeID, "disputeID");
        this.disputeID = disputeID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AcceptDisputeRequest other = (AcceptDisputeRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.disputeID, other.disputeID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, disputeID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AcceptDisputeRequest.class,
                "accountID", accountID,
                "disputeID", disputeID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String disputeID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder disputeID(String disputeID) {
            Utils.checkNotNull(disputeID, "disputeID");
            this.disputeID = disputeID;
            return this;
        }

        public AcceptDisputeRequest build() {

            return new AcceptDisputeRequest(
                accountID, disputeID);
        }

    }
}
