/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.models.components.AmountValidationError;
import io.moov.sdk.models.components.DisplayOptionsError;
import io.moov.sdk.models.components.PaymentDetailsError;
import io.moov.sdk.models.components.PayoutDetailsError;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


@SuppressWarnings("serial")
public class UpdatePaymentLinkError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("amount")
    private Optional<? extends AmountValidationError> amount;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("expiresOn")
    private Optional<String> expiresOn;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("display")
    private Optional<? extends DisplayOptionsError> display;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("payment")
    private Optional<? extends PaymentDetailsError> payment;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("payout")
    private Optional<? extends PayoutDetailsError> payout;

    @JsonCreator
    public UpdatePaymentLinkError(
            @JsonProperty("amount") Optional<? extends AmountValidationError> amount,
            @JsonProperty("expiresOn") Optional<String> expiresOn,
            @JsonProperty("display") Optional<? extends DisplayOptionsError> display,
            @JsonProperty("payment") Optional<? extends PaymentDetailsError> payment,
            @JsonProperty("payout") Optional<? extends PayoutDetailsError> payout) {
        super("API error occurred");
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(expiresOn, "expiresOn");
        Utils.checkNotNull(display, "display");
        Utils.checkNotNull(payment, "payment");
        Utils.checkNotNull(payout, "payout");
        this.amount = amount;
        this.expiresOn = expiresOn;
        this.display = display;
        this.payment = payment;
        this.payout = payout;
    }
    
    public UpdatePaymentLinkError() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AmountValidationError> amount() {
        return (Optional<AmountValidationError>) amount;
    }

    @JsonIgnore
    public Optional<String> expiresOn() {
        return expiresOn;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<DisplayOptionsError> display() {
        return (Optional<DisplayOptionsError>) display;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PaymentDetailsError> payment() {
        return (Optional<PaymentDetailsError>) payment;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PayoutDetailsError> payout() {
        return (Optional<PayoutDetailsError>) payout;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpdatePaymentLinkError withAmount(AmountValidationError amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = Optional.ofNullable(amount);
        return this;
    }


    public UpdatePaymentLinkError withAmount(Optional<? extends AmountValidationError> amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    public UpdatePaymentLinkError withExpiresOn(String expiresOn) {
        Utils.checkNotNull(expiresOn, "expiresOn");
        this.expiresOn = Optional.ofNullable(expiresOn);
        return this;
    }


    public UpdatePaymentLinkError withExpiresOn(Optional<String> expiresOn) {
        Utils.checkNotNull(expiresOn, "expiresOn");
        this.expiresOn = expiresOn;
        return this;
    }

    public UpdatePaymentLinkError withDisplay(DisplayOptionsError display) {
        Utils.checkNotNull(display, "display");
        this.display = Optional.ofNullable(display);
        return this;
    }


    public UpdatePaymentLinkError withDisplay(Optional<? extends DisplayOptionsError> display) {
        Utils.checkNotNull(display, "display");
        this.display = display;
        return this;
    }

    public UpdatePaymentLinkError withPayment(PaymentDetailsError payment) {
        Utils.checkNotNull(payment, "payment");
        this.payment = Optional.ofNullable(payment);
        return this;
    }


    public UpdatePaymentLinkError withPayment(Optional<? extends PaymentDetailsError> payment) {
        Utils.checkNotNull(payment, "payment");
        this.payment = payment;
        return this;
    }

    public UpdatePaymentLinkError withPayout(PayoutDetailsError payout) {
        Utils.checkNotNull(payout, "payout");
        this.payout = Optional.ofNullable(payout);
        return this;
    }


    public UpdatePaymentLinkError withPayout(Optional<? extends PayoutDetailsError> payout) {
        Utils.checkNotNull(payout, "payout");
        this.payout = payout;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdatePaymentLinkError other = (UpdatePaymentLinkError) o;
        return 
            Utils.enhancedDeepEquals(this.amount, other.amount) &&
            Utils.enhancedDeepEquals(this.expiresOn, other.expiresOn) &&
            Utils.enhancedDeepEquals(this.display, other.display) &&
            Utils.enhancedDeepEquals(this.payment, other.payment) &&
            Utils.enhancedDeepEquals(this.payout, other.payout);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            amount, expiresOn, display,
            payment, payout);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdatePaymentLinkError.class,
                "amount", amount,
                "expiresOn", expiresOn,
                "display", display,
                "payment", payment,
                "payout", payout);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends AmountValidationError> amount = Optional.empty();

        private Optional<String> expiresOn = Optional.empty();

        private Optional<? extends DisplayOptionsError> display = Optional.empty();

        private Optional<? extends PaymentDetailsError> payment = Optional.empty();

        private Optional<? extends PayoutDetailsError> payout = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder amount(AmountValidationError amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = Optional.ofNullable(amount);
            return this;
        }

        public Builder amount(Optional<? extends AmountValidationError> amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }


        public Builder expiresOn(String expiresOn) {
            Utils.checkNotNull(expiresOn, "expiresOn");
            this.expiresOn = Optional.ofNullable(expiresOn);
            return this;
        }

        public Builder expiresOn(Optional<String> expiresOn) {
            Utils.checkNotNull(expiresOn, "expiresOn");
            this.expiresOn = expiresOn;
            return this;
        }


        public Builder display(DisplayOptionsError display) {
            Utils.checkNotNull(display, "display");
            this.display = Optional.ofNullable(display);
            return this;
        }

        public Builder display(Optional<? extends DisplayOptionsError> display) {
            Utils.checkNotNull(display, "display");
            this.display = display;
            return this;
        }


        public Builder payment(PaymentDetailsError payment) {
            Utils.checkNotNull(payment, "payment");
            this.payment = Optional.ofNullable(payment);
            return this;
        }

        public Builder payment(Optional<? extends PaymentDetailsError> payment) {
            Utils.checkNotNull(payment, "payment");
            this.payment = payment;
            return this;
        }


        public Builder payout(PayoutDetailsError payout) {
            Utils.checkNotNull(payout, "payout");
            this.payout = Optional.ofNullable(payout);
            return this;
        }

        public Builder payout(Optional<? extends PayoutDetailsError> payout) {
            Utils.checkNotNull(payout, "payout");
            this.payout = payout;
            return this;
        }

        public UpdatePaymentLinkError build() {

            return new UpdatePaymentLinkError(
                amount, expiresOn, display,
                payment, payout);
        }

    }
}

