/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.models.components.PatchAccountError;
import io.moov.sdk.utils.Utils;
import java.io.InputStream;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.Optional;

/**
 * UpdateAccountResponseBody
 * 
 * <p>The request was well-formed, but the contents failed validation. Check the request for missing or invalid fields.
 */
@SuppressWarnings("serial")
public class UpdateAccountResponseBody extends RuntimeException {

    @JsonProperty("error")
    private PatchAccountError error;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("RawResponse")
    private Optional<? extends HttpResponse<InputStream>> rawResponse;

    @JsonCreator
    public UpdateAccountResponseBody(
            @JsonProperty("error") PatchAccountError error,
            @JsonProperty("RawResponse") Optional<? extends HttpResponse<InputStream>> rawResponse) {
        super("API error occurred");
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.error = error;
        this.rawResponse = rawResponse;
    }
    
    public UpdateAccountResponseBody(
            PatchAccountError error) {
        this(error, Optional.empty());
    }

    @JsonIgnore
    public PatchAccountError error() {
        return error;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<HttpResponse<InputStream>> rawResponse() {
        return (Optional<HttpResponse<InputStream>>) rawResponse;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpdateAccountResponseBody withError(PatchAccountError error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public UpdateAccountResponseBody withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = Optional.ofNullable(rawResponse);
        return this;
    }


    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public UpdateAccountResponseBody withRawResponse(Optional<? extends HttpResponse<InputStream>> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateAccountResponseBody other = (UpdateAccountResponseBody) o;
        return 
            Utils.enhancedDeepEquals(this.error, other.error) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            error, rawResponse);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateAccountResponseBody.class,
                "error", error,
                "rawResponse", rawResponse);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private PatchAccountError error;

        private Optional<? extends HttpResponse<InputStream>> rawResponse;

        private Builder() {
          // force use of static builder() method
        }


        public Builder error(PatchAccountError error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = Optional.ofNullable(rawResponse);
            return this;
        }

        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(Optional<? extends HttpResponse<InputStream>> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public UpdateAccountResponseBody build() {

            return new UpdateAccountResponseBody(
                error, rawResponse);
        }

    }
}

