/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


@SuppressWarnings("serial")
public class TerminalApplicationError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("platform")
    private Optional<String> platform;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("appBundleID")
    private Optional<String> appBundleID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("packageName")
    private Optional<String> packageName;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("sha256Digest")
    private Optional<String> sha256Digest;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("versionCode")
    private Optional<String> versionCode;

    @JsonCreator
    public TerminalApplicationError(
            @JsonProperty("platform") Optional<String> platform,
            @JsonProperty("appBundleID") Optional<String> appBundleID,
            @JsonProperty("packageName") Optional<String> packageName,
            @JsonProperty("sha256Digest") Optional<String> sha256Digest,
            @JsonProperty("versionCode") Optional<String> versionCode) {
        super("API error occurred");
        Utils.checkNotNull(platform, "platform");
        Utils.checkNotNull(appBundleID, "appBundleID");
        Utils.checkNotNull(packageName, "packageName");
        Utils.checkNotNull(sha256Digest, "sha256Digest");
        Utils.checkNotNull(versionCode, "versionCode");
        this.platform = platform;
        this.appBundleID = appBundleID;
        this.packageName = packageName;
        this.sha256Digest = sha256Digest;
        this.versionCode = versionCode;
    }
    
    public TerminalApplicationError() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> platform() {
        return platform;
    }

    @JsonIgnore
    public Optional<String> appBundleID() {
        return appBundleID;
    }

    @JsonIgnore
    public Optional<String> packageName() {
        return packageName;
    }

    @JsonIgnore
    public Optional<String> sha256Digest() {
        return sha256Digest;
    }

    @JsonIgnore
    public Optional<String> versionCode() {
        return versionCode;
    }

    public static Builder builder() {
        return new Builder();
    }


    public TerminalApplicationError withPlatform(String platform) {
        Utils.checkNotNull(platform, "platform");
        this.platform = Optional.ofNullable(platform);
        return this;
    }


    public TerminalApplicationError withPlatform(Optional<String> platform) {
        Utils.checkNotNull(platform, "platform");
        this.platform = platform;
        return this;
    }

    public TerminalApplicationError withAppBundleID(String appBundleID) {
        Utils.checkNotNull(appBundleID, "appBundleID");
        this.appBundleID = Optional.ofNullable(appBundleID);
        return this;
    }


    public TerminalApplicationError withAppBundleID(Optional<String> appBundleID) {
        Utils.checkNotNull(appBundleID, "appBundleID");
        this.appBundleID = appBundleID;
        return this;
    }

    public TerminalApplicationError withPackageName(String packageName) {
        Utils.checkNotNull(packageName, "packageName");
        this.packageName = Optional.ofNullable(packageName);
        return this;
    }


    public TerminalApplicationError withPackageName(Optional<String> packageName) {
        Utils.checkNotNull(packageName, "packageName");
        this.packageName = packageName;
        return this;
    }

    public TerminalApplicationError withSha256Digest(String sha256Digest) {
        Utils.checkNotNull(sha256Digest, "sha256Digest");
        this.sha256Digest = Optional.ofNullable(sha256Digest);
        return this;
    }


    public TerminalApplicationError withSha256Digest(Optional<String> sha256Digest) {
        Utils.checkNotNull(sha256Digest, "sha256Digest");
        this.sha256Digest = sha256Digest;
        return this;
    }

    public TerminalApplicationError withVersionCode(String versionCode) {
        Utils.checkNotNull(versionCode, "versionCode");
        this.versionCode = Optional.ofNullable(versionCode);
        return this;
    }


    public TerminalApplicationError withVersionCode(Optional<String> versionCode) {
        Utils.checkNotNull(versionCode, "versionCode");
        this.versionCode = versionCode;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TerminalApplicationError other = (TerminalApplicationError) o;
        return 
            Utils.enhancedDeepEquals(this.platform, other.platform) &&
            Utils.enhancedDeepEquals(this.appBundleID, other.appBundleID) &&
            Utils.enhancedDeepEquals(this.packageName, other.packageName) &&
            Utils.enhancedDeepEquals(this.sha256Digest, other.sha256Digest) &&
            Utils.enhancedDeepEquals(this.versionCode, other.versionCode);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            platform, appBundleID, packageName,
            sha256Digest, versionCode);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TerminalApplicationError.class,
                "platform", platform,
                "appBundleID", appBundleID,
                "packageName", packageName,
                "sha256Digest", sha256Digest,
                "versionCode", versionCode);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> platform = Optional.empty();

        private Optional<String> appBundleID = Optional.empty();

        private Optional<String> packageName = Optional.empty();

        private Optional<String> sha256Digest = Optional.empty();

        private Optional<String> versionCode = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder platform(String platform) {
            Utils.checkNotNull(platform, "platform");
            this.platform = Optional.ofNullable(platform);
            return this;
        }

        public Builder platform(Optional<String> platform) {
            Utils.checkNotNull(platform, "platform");
            this.platform = platform;
            return this;
        }


        public Builder appBundleID(String appBundleID) {
            Utils.checkNotNull(appBundleID, "appBundleID");
            this.appBundleID = Optional.ofNullable(appBundleID);
            return this;
        }

        public Builder appBundleID(Optional<String> appBundleID) {
            Utils.checkNotNull(appBundleID, "appBundleID");
            this.appBundleID = appBundleID;
            return this;
        }


        public Builder packageName(String packageName) {
            Utils.checkNotNull(packageName, "packageName");
            this.packageName = Optional.ofNullable(packageName);
            return this;
        }

        public Builder packageName(Optional<String> packageName) {
            Utils.checkNotNull(packageName, "packageName");
            this.packageName = packageName;
            return this;
        }


        public Builder sha256Digest(String sha256Digest) {
            Utils.checkNotNull(sha256Digest, "sha256Digest");
            this.sha256Digest = Optional.ofNullable(sha256Digest);
            return this;
        }

        public Builder sha256Digest(Optional<String> sha256Digest) {
            Utils.checkNotNull(sha256Digest, "sha256Digest");
            this.sha256Digest = sha256Digest;
            return this;
        }


        public Builder versionCode(String versionCode) {
            Utils.checkNotNull(versionCode, "versionCode");
            this.versionCode = Optional.ofNullable(versionCode);
            return this;
        }

        public Builder versionCode(Optional<String> versionCode) {
            Utils.checkNotNull(versionCode, "versionCode");
            this.versionCode = versionCode;
            return this;
        }

        public TerminalApplicationError build() {

            return new TerminalApplicationError(
                platform, appBundleID, packageName,
                sha256Digest, versionCode);
        }

    }
}

