/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


@SuppressWarnings("serial")
public class ReversalValidationError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("amount")
    private Optional<String> amount;

    @JsonCreator
    public ReversalValidationError(
            @JsonProperty("amount") Optional<String> amount) {
        super("API error occurred");
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
    }
    
    public ReversalValidationError() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<String> amount() {
        return amount;
    }

    public static Builder builder() {
        return new Builder();
    }


    public ReversalValidationError withAmount(String amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = Optional.ofNullable(amount);
        return this;
    }


    public ReversalValidationError withAmount(Optional<String> amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReversalValidationError other = (ReversalValidationError) o;
        return 
            Utils.enhancedDeepEquals(this.amount, other.amount);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            amount);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ReversalValidationError.class,
                "amount", amount);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> amount = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder amount(String amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = Optional.ofNullable(amount);
            return this;
        }

        public Builder amount(Optional<String> amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        public ReversalValidationError build() {

            return new ReversalValidationError(
                amount);
        }

    }
}

