/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.models.components.CardExpirationError;
import io.moov.sdk.models.components.CreateAuthorizedUserError;
import io.moov.sdk.models.components.IssuingControlsError;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


@SuppressWarnings("serial")
public class RequestCardError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("fundingWalletID")
    private Optional<String> fundingWalletID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("formFactor")
    private Optional<String> formFactor;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("authorizedUser")
    private Optional<? extends CreateAuthorizedUserError> authorizedUser;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("memo")
    private Optional<String> memo;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("expiration")
    private Optional<? extends CardExpirationError> expiration;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("controls")
    private Optional<? extends IssuingControlsError> controls;

    @JsonCreator
    public RequestCardError(
            @JsonProperty("fundingWalletID") Optional<String> fundingWalletID,
            @JsonProperty("formFactor") Optional<String> formFactor,
            @JsonProperty("authorizedUser") Optional<? extends CreateAuthorizedUserError> authorizedUser,
            @JsonProperty("memo") Optional<String> memo,
            @JsonProperty("expiration") Optional<? extends CardExpirationError> expiration,
            @JsonProperty("controls") Optional<? extends IssuingControlsError> controls) {
        super("API error occurred");
        Utils.checkNotNull(fundingWalletID, "fundingWalletID");
        Utils.checkNotNull(formFactor, "formFactor");
        Utils.checkNotNull(authorizedUser, "authorizedUser");
        Utils.checkNotNull(memo, "memo");
        Utils.checkNotNull(expiration, "expiration");
        Utils.checkNotNull(controls, "controls");
        this.fundingWalletID = fundingWalletID;
        this.formFactor = formFactor;
        this.authorizedUser = authorizedUser;
        this.memo = memo;
        this.expiration = expiration;
        this.controls = controls;
    }
    
    public RequestCardError() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> fundingWalletID() {
        return fundingWalletID;
    }

    @JsonIgnore
    public Optional<String> formFactor() {
        return formFactor;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateAuthorizedUserError> authorizedUser() {
        return (Optional<CreateAuthorizedUserError>) authorizedUser;
    }

    @JsonIgnore
    public Optional<String> memo() {
        return memo;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardExpirationError> expiration() {
        return (Optional<CardExpirationError>) expiration;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<IssuingControlsError> controls() {
        return (Optional<IssuingControlsError>) controls;
    }

    public static Builder builder() {
        return new Builder();
    }


    public RequestCardError withFundingWalletID(String fundingWalletID) {
        Utils.checkNotNull(fundingWalletID, "fundingWalletID");
        this.fundingWalletID = Optional.ofNullable(fundingWalletID);
        return this;
    }


    public RequestCardError withFundingWalletID(Optional<String> fundingWalletID) {
        Utils.checkNotNull(fundingWalletID, "fundingWalletID");
        this.fundingWalletID = fundingWalletID;
        return this;
    }

    public RequestCardError withFormFactor(String formFactor) {
        Utils.checkNotNull(formFactor, "formFactor");
        this.formFactor = Optional.ofNullable(formFactor);
        return this;
    }


    public RequestCardError withFormFactor(Optional<String> formFactor) {
        Utils.checkNotNull(formFactor, "formFactor");
        this.formFactor = formFactor;
        return this;
    }

    public RequestCardError withAuthorizedUser(CreateAuthorizedUserError authorizedUser) {
        Utils.checkNotNull(authorizedUser, "authorizedUser");
        this.authorizedUser = Optional.ofNullable(authorizedUser);
        return this;
    }


    public RequestCardError withAuthorizedUser(Optional<? extends CreateAuthorizedUserError> authorizedUser) {
        Utils.checkNotNull(authorizedUser, "authorizedUser");
        this.authorizedUser = authorizedUser;
        return this;
    }

    public RequestCardError withMemo(String memo) {
        Utils.checkNotNull(memo, "memo");
        this.memo = Optional.ofNullable(memo);
        return this;
    }


    public RequestCardError withMemo(Optional<String> memo) {
        Utils.checkNotNull(memo, "memo");
        this.memo = memo;
        return this;
    }

    public RequestCardError withExpiration(CardExpirationError expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = Optional.ofNullable(expiration);
        return this;
    }


    public RequestCardError withExpiration(Optional<? extends CardExpirationError> expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = expiration;
        return this;
    }

    public RequestCardError withControls(IssuingControlsError controls) {
        Utils.checkNotNull(controls, "controls");
        this.controls = Optional.ofNullable(controls);
        return this;
    }


    public RequestCardError withControls(Optional<? extends IssuingControlsError> controls) {
        Utils.checkNotNull(controls, "controls");
        this.controls = controls;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RequestCardError other = (RequestCardError) o;
        return 
            Utils.enhancedDeepEquals(this.fundingWalletID, other.fundingWalletID) &&
            Utils.enhancedDeepEquals(this.formFactor, other.formFactor) &&
            Utils.enhancedDeepEquals(this.authorizedUser, other.authorizedUser) &&
            Utils.enhancedDeepEquals(this.memo, other.memo) &&
            Utils.enhancedDeepEquals(this.expiration, other.expiration) &&
            Utils.enhancedDeepEquals(this.controls, other.controls);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            fundingWalletID, formFactor, authorizedUser,
            memo, expiration, controls);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RequestCardError.class,
                "fundingWalletID", fundingWalletID,
                "formFactor", formFactor,
                "authorizedUser", authorizedUser,
                "memo", memo,
                "expiration", expiration,
                "controls", controls);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> fundingWalletID = Optional.empty();

        private Optional<String> formFactor = Optional.empty();

        private Optional<? extends CreateAuthorizedUserError> authorizedUser = Optional.empty();

        private Optional<String> memo = Optional.empty();

        private Optional<? extends CardExpirationError> expiration = Optional.empty();

        private Optional<? extends IssuingControlsError> controls = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder fundingWalletID(String fundingWalletID) {
            Utils.checkNotNull(fundingWalletID, "fundingWalletID");
            this.fundingWalletID = Optional.ofNullable(fundingWalletID);
            return this;
        }

        public Builder fundingWalletID(Optional<String> fundingWalletID) {
            Utils.checkNotNull(fundingWalletID, "fundingWalletID");
            this.fundingWalletID = fundingWalletID;
            return this;
        }


        public Builder formFactor(String formFactor) {
            Utils.checkNotNull(formFactor, "formFactor");
            this.formFactor = Optional.ofNullable(formFactor);
            return this;
        }

        public Builder formFactor(Optional<String> formFactor) {
            Utils.checkNotNull(formFactor, "formFactor");
            this.formFactor = formFactor;
            return this;
        }


        public Builder authorizedUser(CreateAuthorizedUserError authorizedUser) {
            Utils.checkNotNull(authorizedUser, "authorizedUser");
            this.authorizedUser = Optional.ofNullable(authorizedUser);
            return this;
        }

        public Builder authorizedUser(Optional<? extends CreateAuthorizedUserError> authorizedUser) {
            Utils.checkNotNull(authorizedUser, "authorizedUser");
            this.authorizedUser = authorizedUser;
            return this;
        }


        public Builder memo(String memo) {
            Utils.checkNotNull(memo, "memo");
            this.memo = Optional.ofNullable(memo);
            return this;
        }

        public Builder memo(Optional<String> memo) {
            Utils.checkNotNull(memo, "memo");
            this.memo = memo;
            return this;
        }


        public Builder expiration(CardExpirationError expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = Optional.ofNullable(expiration);
            return this;
        }

        public Builder expiration(Optional<? extends CardExpirationError> expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = expiration;
            return this;
        }


        public Builder controls(IssuingControlsError controls) {
            Utils.checkNotNull(controls, "controls");
            this.controls = Optional.ofNullable(controls);
            return this;
        }

        public Builder controls(Optional<? extends IssuingControlsError> controls) {
            Utils.checkNotNull(controls, "controls");
            this.controls = controls;
            return this;
        }

        public RequestCardError build() {

            return new RequestCardError(
                fundingWalletID, formFactor, authorizedUser,
                memo, expiration, controls);
        }

    }
}

