/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;


@SuppressWarnings("serial")
public class GenericError extends RuntimeException {

    @JsonProperty("error")
    private String error;

    @JsonCreator
    public GenericError(
            @JsonProperty("error") String error) {
        super("API error occurred");
        Utils.checkNotNull(error, "error");
        this.error = error;
    }

    @JsonIgnore
    public String error() {
        return error;
    }

    public static Builder builder() {
        return new Builder();
    }


    public GenericError withError(String error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GenericError other = (GenericError) o;
        return 
            Utils.enhancedDeepEquals(this.error, other.error);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            error);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GenericError.class,
                "error", error);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String error;

        private Builder() {
          // force use of static builder() method
        }


        public Builder error(String error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public GenericError build() {

            return new GenericError(
                error);
        }

    }
}

