/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


@SuppressWarnings("serial")
public class FileValidationError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("error")
    private Optional<String> error;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file")
    private Optional<String> file;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("filePurpose")
    private Optional<String> filePurpose;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("metadata")
    private Optional<String> metadata;

    @JsonCreator
    public FileValidationError(
            @JsonProperty("error") Optional<String> error,
            @JsonProperty("file") Optional<String> file,
            @JsonProperty("filePurpose") Optional<String> filePurpose,
            @JsonProperty("metadata") Optional<String> metadata) {
        super("API error occurred");
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(file, "file");
        Utils.checkNotNull(filePurpose, "filePurpose");
        Utils.checkNotNull(metadata, "metadata");
        this.error = error;
        this.file = file;
        this.filePurpose = filePurpose;
        this.metadata = metadata;
    }
    
    public FileValidationError() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    @JsonIgnore
    public Optional<String> error() {
        return error;
    }

    @JsonIgnore
    public Optional<String> file() {
        return file;
    }

    @JsonIgnore
    public Optional<String> filePurpose() {
        return filePurpose;
    }

    @JsonIgnore
    public Optional<String> metadata() {
        return metadata;
    }

    public static Builder builder() {
        return new Builder();
    }


    public FileValidationError withError(String error) {
        Utils.checkNotNull(error, "error");
        this.error = Optional.ofNullable(error);
        return this;
    }


    public FileValidationError withError(Optional<String> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public FileValidationError withFile(String file) {
        Utils.checkNotNull(file, "file");
        this.file = Optional.ofNullable(file);
        return this;
    }


    public FileValidationError withFile(Optional<String> file) {
        Utils.checkNotNull(file, "file");
        this.file = file;
        return this;
    }

    public FileValidationError withFilePurpose(String filePurpose) {
        Utils.checkNotNull(filePurpose, "filePurpose");
        this.filePurpose = Optional.ofNullable(filePurpose);
        return this;
    }


    public FileValidationError withFilePurpose(Optional<String> filePurpose) {
        Utils.checkNotNull(filePurpose, "filePurpose");
        this.filePurpose = filePurpose;
        return this;
    }

    public FileValidationError withMetadata(String metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = Optional.ofNullable(metadata);
        return this;
    }


    public FileValidationError withMetadata(Optional<String> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = metadata;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FileValidationError other = (FileValidationError) o;
        return 
            Utils.enhancedDeepEquals(this.error, other.error) &&
            Utils.enhancedDeepEquals(this.file, other.file) &&
            Utils.enhancedDeepEquals(this.filePurpose, other.filePurpose) &&
            Utils.enhancedDeepEquals(this.metadata, other.metadata);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            error, file, filePurpose,
            metadata);
    }
    
    @Override
    public String toString() {
        return Utils.toString(FileValidationError.class,
                "error", error,
                "file", file,
                "filePurpose", filePurpose,
                "metadata", metadata);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> error = Optional.empty();

        private Optional<String> file = Optional.empty();

        private Optional<String> filePurpose = Optional.empty();

        private Optional<String> metadata = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder error(String error) {
            Utils.checkNotNull(error, "error");
            this.error = Optional.ofNullable(error);
            return this;
        }

        public Builder error(Optional<String> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }


        public Builder file(String file) {
            Utils.checkNotNull(file, "file");
            this.file = Optional.ofNullable(file);
            return this;
        }

        public Builder file(Optional<String> file) {
            Utils.checkNotNull(file, "file");
            this.file = file;
            return this;
        }


        public Builder filePurpose(String filePurpose) {
            Utils.checkNotNull(filePurpose, "filePurpose");
            this.filePurpose = Optional.ofNullable(filePurpose);
            return this;
        }

        public Builder filePurpose(Optional<String> filePurpose) {
            Utils.checkNotNull(filePurpose, "filePurpose");
            this.filePurpose = filePurpose;
            return this;
        }


        public Builder metadata(String metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        public Builder metadata(Optional<String> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = metadata;
            return this;
        }

        public FileValidationError build() {

            return new FileValidationError(
                error, file, filePurpose,
                metadata);
        }

    }
}

