/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


@SuppressWarnings("serial")
public class FileUploadValidationError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("evidenceType")
    private Optional<String> evidenceType;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file")
    private Optional<? extends File> file;

    @JsonCreator
    public FileUploadValidationError(
            @JsonProperty("evidenceType") Optional<String> evidenceType,
            @JsonProperty("file") Optional<? extends File> file) {
        super("API error occurred");
        Utils.checkNotNull(evidenceType, "evidenceType");
        Utils.checkNotNull(file, "file");
        this.evidenceType = evidenceType;
        this.file = file;
    }
    
    public FileUploadValidationError() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> evidenceType() {
        return evidenceType;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<File> file() {
        return (Optional<File>) file;
    }

    public static Builder builder() {
        return new Builder();
    }


    public FileUploadValidationError withEvidenceType(String evidenceType) {
        Utils.checkNotNull(evidenceType, "evidenceType");
        this.evidenceType = Optional.ofNullable(evidenceType);
        return this;
    }


    public FileUploadValidationError withEvidenceType(Optional<String> evidenceType) {
        Utils.checkNotNull(evidenceType, "evidenceType");
        this.evidenceType = evidenceType;
        return this;
    }

    public FileUploadValidationError withFile(File file) {
        Utils.checkNotNull(file, "file");
        this.file = Optional.ofNullable(file);
        return this;
    }


    public FileUploadValidationError withFile(Optional<? extends File> file) {
        Utils.checkNotNull(file, "file");
        this.file = file;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FileUploadValidationError other = (FileUploadValidationError) o;
        return 
            Utils.enhancedDeepEquals(this.evidenceType, other.evidenceType) &&
            Utils.enhancedDeepEquals(this.file, other.file);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            evidenceType, file);
    }
    
    @Override
    public String toString() {
        return Utils.toString(FileUploadValidationError.class,
                "evidenceType", evidenceType,
                "file", file);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> evidenceType = Optional.empty();

        private Optional<? extends File> file = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder evidenceType(String evidenceType) {
            Utils.checkNotNull(evidenceType, "evidenceType");
            this.evidenceType = Optional.ofNullable(evidenceType);
            return this;
        }

        public Builder evidenceType(Optional<String> evidenceType) {
            Utils.checkNotNull(evidenceType, "evidenceType");
            this.evidenceType = evidenceType;
            return this;
        }


        public Builder file(File file) {
            Utils.checkNotNull(file, "file");
            this.file = Optional.ofNullable(file);
            return this;
        }

        public Builder file(Optional<? extends File> file) {
            Utils.checkNotNull(file, "file");
            this.file = file;
            return this;
        }

        public FileUploadValidationError build() {

            return new FileUploadValidationError(
                evidenceType, file);
        }

    }
}

