/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.models.components.CreateTicketContactError;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


@SuppressWarnings("serial")
public class CreateTicketError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("title")
    private Optional<String> title;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("body")
    private Optional<String> body;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("contact")
    private Optional<? extends CreateTicketContactError> contact;

    @JsonCreator
    public CreateTicketError(
            @JsonProperty("title") Optional<String> title,
            @JsonProperty("body") Optional<String> body,
            @JsonProperty("contact") Optional<? extends CreateTicketContactError> contact) {
        super("API error occurred");
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(body, "body");
        Utils.checkNotNull(contact, "contact");
        this.title = title;
        this.body = body;
        this.contact = contact;
    }
    
    public CreateTicketError() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> title() {
        return title;
    }

    @JsonIgnore
    public Optional<String> body() {
        return body;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateTicketContactError> contact() {
        return (Optional<CreateTicketContactError>) contact;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreateTicketError withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = Optional.ofNullable(title);
        return this;
    }


    public CreateTicketError withTitle(Optional<String> title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    public CreateTicketError withBody(String body) {
        Utils.checkNotNull(body, "body");
        this.body = Optional.ofNullable(body);
        return this;
    }


    public CreateTicketError withBody(Optional<String> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public CreateTicketError withContact(CreateTicketContactError contact) {
        Utils.checkNotNull(contact, "contact");
        this.contact = Optional.ofNullable(contact);
        return this;
    }


    public CreateTicketError withContact(Optional<? extends CreateTicketContactError> contact) {
        Utils.checkNotNull(contact, "contact");
        this.contact = contact;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTicketError other = (CreateTicketError) o;
        return 
            Utils.enhancedDeepEquals(this.title, other.title) &&
            Utils.enhancedDeepEquals(this.body, other.body) &&
            Utils.enhancedDeepEquals(this.contact, other.contact);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            title, body, contact);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTicketError.class,
                "title", title,
                "body", body,
                "contact", contact);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> title = Optional.empty();

        private Optional<String> body = Optional.empty();

        private Optional<? extends CreateTicketContactError> contact = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = Optional.ofNullable(title);
            return this;
        }

        public Builder title(Optional<String> title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }


        public Builder body(String body) {
            Utils.checkNotNull(body, "body");
            this.body = Optional.ofNullable(body);
            return this;
        }

        public Builder body(Optional<String> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }


        public Builder contact(CreateTicketContactError contact) {
            Utils.checkNotNull(contact, "contact");
            this.contact = Optional.ofNullable(contact);
            return this;
        }

        public Builder contact(Optional<? extends CreateTicketContactError> contact) {
            Utils.checkNotNull(contact, "contact");
            this.contact = contact;
            return this;
        }

        public CreateTicketError build() {

            return new CreateTicketError(
                title, body, contact);
        }

    }
}

