/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


@SuppressWarnings("serial")
public class BankAccountValidationError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("account")
    private Optional<String> account;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("plaid")
    private Optional<String> plaid;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("plaidLink")
    private Optional<String> plaidLink;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("mx")
    private Optional<String> mx;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("error")
    private Optional<String> error;

    @JsonCreator
    public BankAccountValidationError(
            @JsonProperty("account") Optional<String> account,
            @JsonProperty("plaid") Optional<String> plaid,
            @JsonProperty("plaidLink") Optional<String> plaidLink,
            @JsonProperty("mx") Optional<String> mx,
            @JsonProperty("error") Optional<String> error) {
        super("API error occurred");
        Utils.checkNotNull(account, "account");
        Utils.checkNotNull(plaid, "plaid");
        Utils.checkNotNull(plaidLink, "plaidLink");
        Utils.checkNotNull(mx, "mx");
        Utils.checkNotNull(error, "error");
        this.account = account;
        this.plaid = plaid;
        this.plaidLink = plaidLink;
        this.mx = mx;
        this.error = error;
    }
    
    public BankAccountValidationError() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> account() {
        return account;
    }

    @JsonIgnore
    public Optional<String> plaid() {
        return plaid;
    }

    @JsonIgnore
    public Optional<String> plaidLink() {
        return plaidLink;
    }

    @JsonIgnore
    public Optional<String> mx() {
        return mx;
    }

    @JsonIgnore
    public Optional<String> error() {
        return error;
    }

    public static Builder builder() {
        return new Builder();
    }


    public BankAccountValidationError withAccount(String account) {
        Utils.checkNotNull(account, "account");
        this.account = Optional.ofNullable(account);
        return this;
    }


    public BankAccountValidationError withAccount(Optional<String> account) {
        Utils.checkNotNull(account, "account");
        this.account = account;
        return this;
    }

    public BankAccountValidationError withPlaid(String plaid) {
        Utils.checkNotNull(plaid, "plaid");
        this.plaid = Optional.ofNullable(plaid);
        return this;
    }


    public BankAccountValidationError withPlaid(Optional<String> plaid) {
        Utils.checkNotNull(plaid, "plaid");
        this.plaid = plaid;
        return this;
    }

    public BankAccountValidationError withPlaidLink(String plaidLink) {
        Utils.checkNotNull(plaidLink, "plaidLink");
        this.plaidLink = Optional.ofNullable(plaidLink);
        return this;
    }


    public BankAccountValidationError withPlaidLink(Optional<String> plaidLink) {
        Utils.checkNotNull(plaidLink, "plaidLink");
        this.plaidLink = plaidLink;
        return this;
    }

    public BankAccountValidationError withMx(String mx) {
        Utils.checkNotNull(mx, "mx");
        this.mx = Optional.ofNullable(mx);
        return this;
    }


    public BankAccountValidationError withMx(Optional<String> mx) {
        Utils.checkNotNull(mx, "mx");
        this.mx = mx;
        return this;
    }

    public BankAccountValidationError withError(String error) {
        Utils.checkNotNull(error, "error");
        this.error = Optional.ofNullable(error);
        return this;
    }


    public BankAccountValidationError withError(Optional<String> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BankAccountValidationError other = (BankAccountValidationError) o;
        return 
            Utils.enhancedDeepEquals(this.account, other.account) &&
            Utils.enhancedDeepEquals(this.plaid, other.plaid) &&
            Utils.enhancedDeepEquals(this.plaidLink, other.plaidLink) &&
            Utils.enhancedDeepEquals(this.mx, other.mx) &&
            Utils.enhancedDeepEquals(this.error, other.error);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            account, plaid, plaidLink,
            mx, error);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BankAccountValidationError.class,
                "account", account,
                "plaid", plaid,
                "plaidLink", plaidLink,
                "mx", mx,
                "error", error);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> account = Optional.empty();

        private Optional<String> plaid = Optional.empty();

        private Optional<String> plaidLink = Optional.empty();

        private Optional<String> mx = Optional.empty();

        private Optional<String> error = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder account(String account) {
            Utils.checkNotNull(account, "account");
            this.account = Optional.ofNullable(account);
            return this;
        }

        public Builder account(Optional<String> account) {
            Utils.checkNotNull(account, "account");
            this.account = account;
            return this;
        }


        public Builder plaid(String plaid) {
            Utils.checkNotNull(plaid, "plaid");
            this.plaid = Optional.ofNullable(plaid);
            return this;
        }

        public Builder plaid(Optional<String> plaid) {
            Utils.checkNotNull(plaid, "plaid");
            this.plaid = plaid;
            return this;
        }


        public Builder plaidLink(String plaidLink) {
            Utils.checkNotNull(plaidLink, "plaidLink");
            this.plaidLink = Optional.ofNullable(plaidLink);
            return this;
        }

        public Builder plaidLink(Optional<String> plaidLink) {
            Utils.checkNotNull(plaidLink, "plaidLink");
            this.plaidLink = plaidLink;
            return this;
        }


        public Builder mx(String mx) {
            Utils.checkNotNull(mx, "mx");
            this.mx = Optional.ofNullable(mx);
            return this;
        }

        public Builder mx(Optional<String> mx) {
            Utils.checkNotNull(mx, "mx");
            this.mx = mx;
            return this;
        }


        public Builder error(String error) {
            Utils.checkNotNull(error, "error");
            this.error = Optional.ofNullable(error);
            return this;
        }

        public Builder error(Optional<String> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public BankAccountValidationError build() {

            return new BankAccountValidationError(
                account, plaid, plaidLink,
                mx, error);
        }

    }
}

