/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;


public class WireServices {
    /**
     * The institution's capability to process standard Fedwire funds transfers.
     */
    @JsonProperty("fundsTransferStatus")
    private boolean fundsTransferStatus;

    /**
     * The institution's capability for settlement-only transfers.
     */
    @JsonProperty("fundsSettlementOnlyStatus")
    private boolean fundsSettlementOnlyStatus;

    /**
     * The institution's capability to handle transfers of securities.
     */
    @JsonProperty("bookEntrySecuritiesTransferStatus")
    private boolean bookEntrySecuritiesTransferStatus;

    @JsonCreator
    public WireServices(
            @JsonProperty("fundsTransferStatus") boolean fundsTransferStatus,
            @JsonProperty("fundsSettlementOnlyStatus") boolean fundsSettlementOnlyStatus,
            @JsonProperty("bookEntrySecuritiesTransferStatus") boolean bookEntrySecuritiesTransferStatus) {
        Utils.checkNotNull(fundsTransferStatus, "fundsTransferStatus");
        Utils.checkNotNull(fundsSettlementOnlyStatus, "fundsSettlementOnlyStatus");
        Utils.checkNotNull(bookEntrySecuritiesTransferStatus, "bookEntrySecuritiesTransferStatus");
        this.fundsTransferStatus = fundsTransferStatus;
        this.fundsSettlementOnlyStatus = fundsSettlementOnlyStatus;
        this.bookEntrySecuritiesTransferStatus = bookEntrySecuritiesTransferStatus;
    }

    /**
     * The institution's capability to process standard Fedwire funds transfers.
     */
    @JsonIgnore
    public boolean fundsTransferStatus() {
        return fundsTransferStatus;
    }

    /**
     * The institution's capability for settlement-only transfers.
     */
    @JsonIgnore
    public boolean fundsSettlementOnlyStatus() {
        return fundsSettlementOnlyStatus;
    }

    /**
     * The institution's capability to handle transfers of securities.
     */
    @JsonIgnore
    public boolean bookEntrySecuritiesTransferStatus() {
        return bookEntrySecuritiesTransferStatus;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The institution's capability to process standard Fedwire funds transfers.
     */
    public WireServices withFundsTransferStatus(boolean fundsTransferStatus) {
        Utils.checkNotNull(fundsTransferStatus, "fundsTransferStatus");
        this.fundsTransferStatus = fundsTransferStatus;
        return this;
    }

    /**
     * The institution's capability for settlement-only transfers.
     */
    public WireServices withFundsSettlementOnlyStatus(boolean fundsSettlementOnlyStatus) {
        Utils.checkNotNull(fundsSettlementOnlyStatus, "fundsSettlementOnlyStatus");
        this.fundsSettlementOnlyStatus = fundsSettlementOnlyStatus;
        return this;
    }

    /**
     * The institution's capability to handle transfers of securities.
     */
    public WireServices withBookEntrySecuritiesTransferStatus(boolean bookEntrySecuritiesTransferStatus) {
        Utils.checkNotNull(bookEntrySecuritiesTransferStatus, "bookEntrySecuritiesTransferStatus");
        this.bookEntrySecuritiesTransferStatus = bookEntrySecuritiesTransferStatus;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WireServices other = (WireServices) o;
        return 
            Utils.enhancedDeepEquals(this.fundsTransferStatus, other.fundsTransferStatus) &&
            Utils.enhancedDeepEquals(this.fundsSettlementOnlyStatus, other.fundsSettlementOnlyStatus) &&
            Utils.enhancedDeepEquals(this.bookEntrySecuritiesTransferStatus, other.bookEntrySecuritiesTransferStatus);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            fundsTransferStatus, fundsSettlementOnlyStatus, bookEntrySecuritiesTransferStatus);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WireServices.class,
                "fundsTransferStatus", fundsTransferStatus,
                "fundsSettlementOnlyStatus", fundsSettlementOnlyStatus,
                "bookEntrySecuritiesTransferStatus", bookEntrySecuritiesTransferStatus);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Boolean fundsTransferStatus;

        private Boolean fundsSettlementOnlyStatus;

        private Boolean bookEntrySecuritiesTransferStatus;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The institution's capability to process standard Fedwire funds transfers.
         */
        public Builder fundsTransferStatus(boolean fundsTransferStatus) {
            Utils.checkNotNull(fundsTransferStatus, "fundsTransferStatus");
            this.fundsTransferStatus = fundsTransferStatus;
            return this;
        }


        /**
         * The institution's capability for settlement-only transfers.
         */
        public Builder fundsSettlementOnlyStatus(boolean fundsSettlementOnlyStatus) {
            Utils.checkNotNull(fundsSettlementOnlyStatus, "fundsSettlementOnlyStatus");
            this.fundsSettlementOnlyStatus = fundsSettlementOnlyStatus;
            return this;
        }


        /**
         * The institution's capability to handle transfers of securities.
         */
        public Builder bookEntrySecuritiesTransferStatus(boolean bookEntrySecuritiesTransferStatus) {
            Utils.checkNotNull(bookEntrySecuritiesTransferStatus, "bookEntrySecuritiesTransferStatus");
            this.bookEntrySecuritiesTransferStatus = bookEntrySecuritiesTransferStatus;
            return this;
        }

        public WireServices build() {

            return new WireServices(
                fundsTransferStatus, fundsSettlementOnlyStatus, bookEntrySecuritiesTransferStatus);
        }

    }
}
