/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;

/**
 * WebhookTransferPaymentMethodDetails
 * 
 * <p>Payment method details for the source or destination of a transfer.
 */
public class WebhookTransferPaymentMethodDetails {

    @JsonProperty("accountID")
    private String accountID;


    @JsonProperty("paymentMethodID")
    private String paymentMethodID;

    @JsonCreator
    public WebhookTransferPaymentMethodDetails(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("paymentMethodID") String paymentMethodID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.accountID = accountID;
        this.paymentMethodID = paymentMethodID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String paymentMethodID() {
        return paymentMethodID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public WebhookTransferPaymentMethodDetails withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookTransferPaymentMethodDetails withPaymentMethodID(String paymentMethodID) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.paymentMethodID = paymentMethodID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookTransferPaymentMethodDetails other = (WebhookTransferPaymentMethodDetails) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.paymentMethodID, other.paymentMethodID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, paymentMethodID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookTransferPaymentMethodDetails.class,
                "accountID", accountID,
                "paymentMethodID", paymentMethodID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String paymentMethodID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder paymentMethodID(String paymentMethodID) {
            Utils.checkNotNull(paymentMethodID, "paymentMethodID");
            this.paymentMethodID = paymentMethodID;
            return this;
        }

        public WebhookTransferPaymentMethodDetails build() {

            return new WebhookTransferPaymentMethodDetails(
                accountID, paymentMethodID);
        }

    }
}
