/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;

/**
 * WebhookEvent
 * 
 * <p>Webhook events are sent to your webhook URL when certain actions occur in the Moov API. You can subscribe to these events to receive real-time notifications.
 */
public class WebhookEvent {
    /**
     * Unique identifier for the webhook event.
     */
    @JsonProperty("eventID")
    private String eventID;

    /**
     * The type of event that occurred.
     */
    @JsonProperty("type")
    private WebhookEventType type;

    /**
     * The data for the webhook event. The contents are based on the event type.
     */
    @JsonProperty("data")
    private WebhookData data;


    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;

    @JsonCreator
    public WebhookEvent(
            @JsonProperty("eventID") String eventID,
            @JsonProperty("type") WebhookEventType type,
            @JsonProperty("data") WebhookData data,
            @JsonProperty("createdOn") OffsetDateTime createdOn) {
        Utils.checkNotNull(eventID, "eventID");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(createdOn, "createdOn");
        this.eventID = eventID;
        this.type = type;
        this.data = data;
        this.createdOn = createdOn;
    }

    /**
     * Unique identifier for the webhook event.
     */
    @JsonIgnore
    public String eventID() {
        return eventID;
    }

    /**
     * The type of event that occurred.
     */
    @JsonIgnore
    public WebhookEventType type() {
        return type;
    }

    /**
     * The data for the webhook event. The contents are based on the event type.
     */
    @JsonIgnore
    public WebhookData data() {
        return data;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier for the webhook event.
     */
    public WebhookEvent withEventID(String eventID) {
        Utils.checkNotNull(eventID, "eventID");
        this.eventID = eventID;
        return this;
    }

    /**
     * The type of event that occurred.
     */
    public WebhookEvent withType(WebhookEventType type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * The data for the webhook event. The contents are based on the event type.
     */
    public WebhookEvent withData(WebhookData data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public WebhookEvent withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookEvent other = (WebhookEvent) o;
        return 
            Utils.enhancedDeepEquals(this.eventID, other.eventID) &&
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.data, other.data) &&
            Utils.enhancedDeepEquals(this.createdOn, other.createdOn);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            eventID, type, data,
            createdOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookEvent.class,
                "eventID", eventID,
                "type", type,
                "data", data,
                "createdOn", createdOn);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String eventID;

        private WebhookEventType type;

        private WebhookData data;

        private OffsetDateTime createdOn;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier for the webhook event.
         */
        public Builder eventID(String eventID) {
            Utils.checkNotNull(eventID, "eventID");
            this.eventID = eventID;
            return this;
        }


        /**
         * The type of event that occurred.
         */
        public Builder type(WebhookEventType type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        /**
         * The data for the webhook event. The contents are based on the event type.
         */
        public Builder data(WebhookData data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }


        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }

        public WebhookEvent build() {

            return new WebhookEvent(
                eventID, type, data,
                createdOn);
        }

    }
}
