/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class WebhookDataWalletTransactionUpdated {

    @JsonProperty("accountID")
    private String accountID;


    @JsonProperty("walletID")
    private String walletID;


    @JsonProperty("transactionID")
    private String transactionID;


    @JsonProperty("status")
    private WalletTransactionStatus status;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("availableBalance")
    private Optional<? extends WalletAvailableBalance> availableBalance;

    @JsonCreator
    public WebhookDataWalletTransactionUpdated(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("walletID") String walletID,
            @JsonProperty("transactionID") String transactionID,
            @JsonProperty("status") WalletTransactionStatus status,
            @JsonProperty("availableBalance") Optional<? extends WalletAvailableBalance> availableBalance) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(walletID, "walletID");
        Utils.checkNotNull(transactionID, "transactionID");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(availableBalance, "availableBalance");
        this.accountID = accountID;
        this.walletID = walletID;
        this.transactionID = transactionID;
        this.status = status;
        this.availableBalance = availableBalance;
    }
    
    public WebhookDataWalletTransactionUpdated(
            String accountID,
            String walletID,
            String transactionID,
            WalletTransactionStatus status) {
        this(accountID, walletID, transactionID,
            status, Optional.empty());
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String walletID() {
        return walletID;
    }

    @JsonIgnore
    public String transactionID() {
        return transactionID;
    }

    @JsonIgnore
    public WalletTransactionStatus status() {
        return status;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<WalletAvailableBalance> availableBalance() {
        return (Optional<WalletAvailableBalance>) availableBalance;
    }

    public static Builder builder() {
        return new Builder();
    }


    public WebhookDataWalletTransactionUpdated withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataWalletTransactionUpdated withWalletID(String walletID) {
        Utils.checkNotNull(walletID, "walletID");
        this.walletID = walletID;
        return this;
    }

    public WebhookDataWalletTransactionUpdated withTransactionID(String transactionID) {
        Utils.checkNotNull(transactionID, "transactionID");
        this.transactionID = transactionID;
        return this;
    }

    public WebhookDataWalletTransactionUpdated withStatus(WalletTransactionStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public WebhookDataWalletTransactionUpdated withAvailableBalance(WalletAvailableBalance availableBalance) {
        Utils.checkNotNull(availableBalance, "availableBalance");
        this.availableBalance = Optional.ofNullable(availableBalance);
        return this;
    }


    public WebhookDataWalletTransactionUpdated withAvailableBalance(Optional<? extends WalletAvailableBalance> availableBalance) {
        Utils.checkNotNull(availableBalance, "availableBalance");
        this.availableBalance = availableBalance;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataWalletTransactionUpdated other = (WebhookDataWalletTransactionUpdated) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.walletID, other.walletID) &&
            Utils.enhancedDeepEquals(this.transactionID, other.transactionID) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.availableBalance, other.availableBalance);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, walletID, transactionID,
            status, availableBalance);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataWalletTransactionUpdated.class,
                "accountID", accountID,
                "walletID", walletID,
                "transactionID", transactionID,
                "status", status,
                "availableBalance", availableBalance);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String walletID;

        private String transactionID;

        private WalletTransactionStatus status;

        private Optional<? extends WalletAvailableBalance> availableBalance = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder walletID(String walletID) {
            Utils.checkNotNull(walletID, "walletID");
            this.walletID = walletID;
            return this;
        }


        public Builder transactionID(String transactionID) {
            Utils.checkNotNull(transactionID, "transactionID");
            this.transactionID = transactionID;
            return this;
        }


        public Builder status(WalletTransactionStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        public Builder availableBalance(WalletAvailableBalance availableBalance) {
            Utils.checkNotNull(availableBalance, "availableBalance");
            this.availableBalance = Optional.ofNullable(availableBalance);
            return this;
        }

        public Builder availableBalance(Optional<? extends WalletAvailableBalance> availableBalance) {
            Utils.checkNotNull(availableBalance, "availableBalance");
            this.availableBalance = availableBalance;
            return this;
        }

        public WebhookDataWalletTransactionUpdated build() {

            return new WebhookDataWalletTransactionUpdated(
                accountID, walletID, transactionID,
                status, availableBalance);
        }

    }
}
