/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class WebhookDataTransferUpdated {
    /**
     * The accountID which facilitated the transfer.
     */
    @JsonProperty("accountID")
    private String accountID;


    @JsonProperty("transferID")
    private String transferID;


    @JsonProperty("status")
    private WebhookDataTransferStatus status;

    /**
     * Payment method details for the source or destination of a transfer.
     */
    @JsonProperty("source")
    private WebhookTransferPaymentMethodDetails source;

    /**
     * Payment method details for the source or destination of a transfer.
     */
    @JsonProperty("destination")
    private WebhookTransferPaymentMethodDetails destination;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("foreignID")
    private Optional<String> foreignID;

    @JsonCreator
    public WebhookDataTransferUpdated(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("transferID") String transferID,
            @JsonProperty("status") WebhookDataTransferStatus status,
            @JsonProperty("source") WebhookTransferPaymentMethodDetails source,
            @JsonProperty("destination") WebhookTransferPaymentMethodDetails destination,
            @JsonProperty("foreignID") Optional<String> foreignID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(source, "source");
        Utils.checkNotNull(destination, "destination");
        Utils.checkNotNull(foreignID, "foreignID");
        this.accountID = accountID;
        this.transferID = transferID;
        this.status = status;
        this.source = source;
        this.destination = destination;
        this.foreignID = foreignID;
    }
    
    public WebhookDataTransferUpdated(
            String accountID,
            String transferID,
            WebhookDataTransferStatus status,
            WebhookTransferPaymentMethodDetails source,
            WebhookTransferPaymentMethodDetails destination) {
        this(accountID, transferID, status,
            source, destination, Optional.empty());
    }

    /**
     * The accountID which facilitated the transfer.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    @JsonIgnore
    public WebhookDataTransferStatus status() {
        return status;
    }

    /**
     * Payment method details for the source or destination of a transfer.
     */
    @JsonIgnore
    public WebhookTransferPaymentMethodDetails source() {
        return source;
    }

    /**
     * Payment method details for the source or destination of a transfer.
     */
    @JsonIgnore
    public WebhookTransferPaymentMethodDetails destination() {
        return destination;
    }

    @JsonIgnore
    public Optional<String> foreignID() {
        return foreignID;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The accountID which facilitated the transfer.
     */
    public WebhookDataTransferUpdated withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataTransferUpdated withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public WebhookDataTransferUpdated withStatus(WebhookDataTransferStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * Payment method details for the source or destination of a transfer.
     */
    public WebhookDataTransferUpdated withSource(WebhookTransferPaymentMethodDetails source) {
        Utils.checkNotNull(source, "source");
        this.source = source;
        return this;
    }

    /**
     * Payment method details for the source or destination of a transfer.
     */
    public WebhookDataTransferUpdated withDestination(WebhookTransferPaymentMethodDetails destination) {
        Utils.checkNotNull(destination, "destination");
        this.destination = destination;
        return this;
    }

    public WebhookDataTransferUpdated withForeignID(String foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = Optional.ofNullable(foreignID);
        return this;
    }


    public WebhookDataTransferUpdated withForeignID(Optional<String> foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = foreignID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataTransferUpdated other = (WebhookDataTransferUpdated) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.transferID, other.transferID) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.source, other.source) &&
            Utils.enhancedDeepEquals(this.destination, other.destination) &&
            Utils.enhancedDeepEquals(this.foreignID, other.foreignID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, transferID, status,
            source, destination, foreignID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataTransferUpdated.class,
                "accountID", accountID,
                "transferID", transferID,
                "status", status,
                "source", source,
                "destination", destination,
                "foreignID", foreignID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String transferID;

        private WebhookDataTransferStatus status;

        private WebhookTransferPaymentMethodDetails source;

        private WebhookTransferPaymentMethodDetails destination;

        private Optional<String> foreignID = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The accountID which facilitated the transfer.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }


        public Builder status(WebhookDataTransferStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * Payment method details for the source or destination of a transfer.
         */
        public Builder source(WebhookTransferPaymentMethodDetails source) {
            Utils.checkNotNull(source, "source");
            this.source = source;
            return this;
        }


        /**
         * Payment method details for the source or destination of a transfer.
         */
        public Builder destination(WebhookTransferPaymentMethodDetails destination) {
            Utils.checkNotNull(destination, "destination");
            this.destination = destination;
            return this;
        }


        public Builder foreignID(String foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = Optional.ofNullable(foreignID);
            return this;
        }

        public Builder foreignID(Optional<String> foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = foreignID;
            return this;
        }

        public WebhookDataTransferUpdated build() {

            return new WebhookDataTransferUpdated(
                accountID, transferID, status,
                source, destination, foreignID);
        }

    }
}
