/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class WebhookDataTransferCreated {
    /**
     * The accountID which facilitated the transfer.
     */
    @JsonProperty("accountID")
    private String accountID;


    @JsonProperty("transferID")
    private String transferID;


    @JsonProperty("status")
    private WebhookDataTransferStatus status;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("foreignID")
    private Optional<String> foreignID;

    @JsonCreator
    public WebhookDataTransferCreated(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("transferID") String transferID,
            @JsonProperty("status") WebhookDataTransferStatus status,
            @JsonProperty("foreignID") Optional<String> foreignID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(foreignID, "foreignID");
        this.accountID = accountID;
        this.transferID = transferID;
        this.status = status;
        this.foreignID = foreignID;
    }
    
    public WebhookDataTransferCreated(
            String accountID,
            String transferID,
            WebhookDataTransferStatus status) {
        this(accountID, transferID, status,
            Optional.empty());
    }

    /**
     * The accountID which facilitated the transfer.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    @JsonIgnore
    public WebhookDataTransferStatus status() {
        return status;
    }

    @JsonIgnore
    public Optional<String> foreignID() {
        return foreignID;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The accountID which facilitated the transfer.
     */
    public WebhookDataTransferCreated withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataTransferCreated withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public WebhookDataTransferCreated withStatus(WebhookDataTransferStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public WebhookDataTransferCreated withForeignID(String foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = Optional.ofNullable(foreignID);
        return this;
    }


    public WebhookDataTransferCreated withForeignID(Optional<String> foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = foreignID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataTransferCreated other = (WebhookDataTransferCreated) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.transferID, other.transferID) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.foreignID, other.foreignID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, transferID, status,
            foreignID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataTransferCreated.class,
                "accountID", accountID,
                "transferID", transferID,
                "status", status,
                "foreignID", foreignID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String transferID;

        private WebhookDataTransferStatus status;

        private Optional<String> foreignID = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The accountID which facilitated the transfer.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }


        public Builder status(WebhookDataTransferStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        public Builder foreignID(String foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = Optional.ofNullable(foreignID);
            return this;
        }

        public Builder foreignID(Optional<String> foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = foreignID;
            return this;
        }

        public WebhookDataTransferCreated build() {

            return new WebhookDataTransferCreated(
                accountID, transferID, status,
                foreignID);
        }

    }
}
