/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class WebhookDataRefundCreated {

    @JsonProperty("accountID")
    private String accountID;


    @JsonProperty("transferID")
    private String transferID;


    @JsonProperty("refundID")
    private String refundID;

    @JsonCreator
    public WebhookDataRefundCreated(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("transferID") String transferID,
            @JsonProperty("refundID") String refundID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(refundID, "refundID");
        this.accountID = accountID;
        this.transferID = transferID;
        this.refundID = refundID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    @JsonIgnore
    public String refundID() {
        return refundID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public WebhookDataRefundCreated withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataRefundCreated withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public WebhookDataRefundCreated withRefundID(String refundID) {
        Utils.checkNotNull(refundID, "refundID");
        this.refundID = refundID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataRefundCreated other = (WebhookDataRefundCreated) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.transferID, other.transferID) &&
            Utils.enhancedDeepEquals(this.refundID, other.refundID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, transferID, refundID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataRefundCreated.class,
                "accountID", accountID,
                "transferID", transferID,
                "refundID", refundID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String transferID;

        private String refundID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }


        public Builder refundID(String refundID) {
            Utils.checkNotNull(refundID, "refundID");
            this.refundID = refundID;
            return this;
        }

        public WebhookDataRefundCreated build() {

            return new WebhookDataRefundCreated(
                accountID, transferID, refundID);
        }

    }
}
