/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class WebhookDataDisputeCreated {

    @JsonProperty("accountID")
    private String accountID;


    @JsonProperty("transferID")
    private String transferID;


    @JsonProperty("transactionID")
    private String transactionID;


    @JsonProperty("disputeID")
    private String disputeID;

    /**
     * The status of a particular dispute. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/#dispute-statuses) to learn what each status means.
     */
    @JsonProperty("status")
    private DisputeStatus status;

    /**
     * The phase of a dispute within the dispute lifecycle.
     */
    @JsonProperty("phase")
    private DisputePhase phase;

    @JsonCreator
    public WebhookDataDisputeCreated(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("transferID") String transferID,
            @JsonProperty("transactionID") String transactionID,
            @JsonProperty("disputeID") String disputeID,
            @JsonProperty("status") DisputeStatus status,
            @JsonProperty("phase") DisputePhase phase) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(transactionID, "transactionID");
        Utils.checkNotNull(disputeID, "disputeID");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(phase, "phase");
        this.accountID = accountID;
        this.transferID = transferID;
        this.transactionID = transactionID;
        this.disputeID = disputeID;
        this.status = status;
        this.phase = phase;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    @JsonIgnore
    public String transactionID() {
        return transactionID;
    }

    @JsonIgnore
    public String disputeID() {
        return disputeID;
    }

    /**
     * The status of a particular dispute. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/#dispute-statuses) to learn what each status means.
     */
    @JsonIgnore
    public DisputeStatus status() {
        return status;
    }

    /**
     * The phase of a dispute within the dispute lifecycle.
     */
    @JsonIgnore
    public DisputePhase phase() {
        return phase;
    }

    public static Builder builder() {
        return new Builder();
    }


    public WebhookDataDisputeCreated withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataDisputeCreated withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public WebhookDataDisputeCreated withTransactionID(String transactionID) {
        Utils.checkNotNull(transactionID, "transactionID");
        this.transactionID = transactionID;
        return this;
    }

    public WebhookDataDisputeCreated withDisputeID(String disputeID) {
        Utils.checkNotNull(disputeID, "disputeID");
        this.disputeID = disputeID;
        return this;
    }

    /**
     * The status of a particular dispute. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/#dispute-statuses) to learn what each status means.
     */
    public WebhookDataDisputeCreated withStatus(DisputeStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The phase of a dispute within the dispute lifecycle.
     */
    public WebhookDataDisputeCreated withPhase(DisputePhase phase) {
        Utils.checkNotNull(phase, "phase");
        this.phase = phase;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataDisputeCreated other = (WebhookDataDisputeCreated) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.transferID, other.transferID) &&
            Utils.enhancedDeepEquals(this.transactionID, other.transactionID) &&
            Utils.enhancedDeepEquals(this.disputeID, other.disputeID) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.phase, other.phase);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, transferID, transactionID,
            disputeID, status, phase);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataDisputeCreated.class,
                "accountID", accountID,
                "transferID", transferID,
                "transactionID", transactionID,
                "disputeID", disputeID,
                "status", status,
                "phase", phase);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String transferID;

        private String transactionID;

        private String disputeID;

        private DisputeStatus status;

        private DisputePhase phase;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }


        public Builder transactionID(String transactionID) {
            Utils.checkNotNull(transactionID, "transactionID");
            this.transactionID = transactionID;
            return this;
        }


        public Builder disputeID(String disputeID) {
            Utils.checkNotNull(disputeID, "disputeID");
            this.disputeID = disputeID;
            return this;
        }


        /**
         * The status of a particular dispute. 
         * 
         * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/#dispute-statuses) to learn what each status means.
         */
        public Builder status(DisputeStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * The phase of a dispute within the dispute lifecycle.
         */
        public Builder phase(DisputePhase phase) {
            Utils.checkNotNull(phase, "phase");
            this.phase = phase;
            return this;
        }

        public WebhookDataDisputeCreated build() {

            return new WebhookDataDisputeCreated(
                accountID, transferID, transactionID,
                disputeID, status, phase);
        }

    }
}
