/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class WebhookDataCardAutoUpdated {

    @JsonProperty("cardID")
    private String cardID;


    @JsonProperty("accountID")
    private String accountID;

    /**
     * The results of the card update request.
     */
    @JsonProperty("updateType")
    private CardUpdateReason updateType;

    @JsonCreator
    public WebhookDataCardAutoUpdated(
            @JsonProperty("cardID") String cardID,
            @JsonProperty("accountID") String accountID,
            @JsonProperty("updateType") CardUpdateReason updateType) {
        Utils.checkNotNull(cardID, "cardID");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(updateType, "updateType");
        this.cardID = cardID;
        this.accountID = accountID;
        this.updateType = updateType;
    }

    @JsonIgnore
    public String cardID() {
        return cardID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * The results of the card update request.
     */
    @JsonIgnore
    public CardUpdateReason updateType() {
        return updateType;
    }

    public static Builder builder() {
        return new Builder();
    }


    public WebhookDataCardAutoUpdated withCardID(String cardID) {
        Utils.checkNotNull(cardID, "cardID");
        this.cardID = cardID;
        return this;
    }

    public WebhookDataCardAutoUpdated withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * The results of the card update request.
     */
    public WebhookDataCardAutoUpdated withUpdateType(CardUpdateReason updateType) {
        Utils.checkNotNull(updateType, "updateType");
        this.updateType = updateType;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataCardAutoUpdated other = (WebhookDataCardAutoUpdated) o;
        return 
            Utils.enhancedDeepEquals(this.cardID, other.cardID) &&
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.updateType, other.updateType);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            cardID, accountID, updateType);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataCardAutoUpdated.class,
                "cardID", cardID,
                "accountID", accountID,
                "updateType", updateType);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String cardID;

        private String accountID;

        private CardUpdateReason updateType;

        private Builder() {
          // force use of static builder() method
        }


        public Builder cardID(String cardID) {
            Utils.checkNotNull(cardID, "cardID");
            this.cardID = cardID;
            return this;
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * The results of the card update request.
         */
        public Builder updateType(CardUpdateReason updateType) {
            Utils.checkNotNull(updateType, "updateType");
            this.updateType = updateType;
            return this;
        }

        public WebhookDataCardAutoUpdated build() {

            return new WebhookDataCardAutoUpdated(
                cardID, accountID, updateType);
        }

    }
}
