/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class WebhookDataCapabilityRequested {

    @JsonProperty("accountID")
    private String accountID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("foreignID")
    private Optional<String> foreignID;

    /**
     * Moov account capabilities.
     * 
     * <p>The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
     */
    @JsonProperty("capabilityID")
    private CapabilityID capabilityID;

    @JsonCreator
    public WebhookDataCapabilityRequested(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("foreignID") Optional<String> foreignID,
            @JsonProperty("capabilityID") CapabilityID capabilityID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(foreignID, "foreignID");
        Utils.checkNotNull(capabilityID, "capabilityID");
        this.accountID = accountID;
        this.foreignID = foreignID;
        this.capabilityID = capabilityID;
    }
    
    public WebhookDataCapabilityRequested(
            String accountID,
            CapabilityID capabilityID) {
        this(accountID, Optional.empty(), capabilityID);
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public Optional<String> foreignID() {
        return foreignID;
    }

    /**
     * Moov account capabilities.
     * 
     * <p>The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
     */
    @JsonIgnore
    public CapabilityID capabilityID() {
        return capabilityID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public WebhookDataCapabilityRequested withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataCapabilityRequested withForeignID(String foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = Optional.ofNullable(foreignID);
        return this;
    }


    public WebhookDataCapabilityRequested withForeignID(Optional<String> foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = foreignID;
        return this;
    }

    /**
     * Moov account capabilities.
     * 
     * <p>The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
     */
    public WebhookDataCapabilityRequested withCapabilityID(CapabilityID capabilityID) {
        Utils.checkNotNull(capabilityID, "capabilityID");
        this.capabilityID = capabilityID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataCapabilityRequested other = (WebhookDataCapabilityRequested) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.foreignID, other.foreignID) &&
            Utils.enhancedDeepEquals(this.capabilityID, other.capabilityID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, foreignID, capabilityID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataCapabilityRequested.class,
                "accountID", accountID,
                "foreignID", foreignID,
                "capabilityID", capabilityID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private Optional<String> foreignID = Optional.empty();

        private CapabilityID capabilityID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder foreignID(String foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = Optional.ofNullable(foreignID);
            return this;
        }

        public Builder foreignID(Optional<String> foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = foreignID;
            return this;
        }


        /**
         * Moov account capabilities.
         * 
         * <p>The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
         */
        public Builder capabilityID(CapabilityID capabilityID) {
            Utils.checkNotNull(capabilityID, "capabilityID");
            this.capabilityID = capabilityID;
            return this;
        }

        public WebhookDataCapabilityRequested build() {

            return new WebhookDataCapabilityRequested(
                accountID, foreignID, capabilityID);
        }

    }
}
