/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class WebhookDataBankAccountUpdated {

    @JsonProperty("bankAccountID")
    private String bankAccountID;


    @JsonProperty("accountID")
    private String accountID;


    @JsonProperty("status")
    private BankAccountStatus status;

    /**
     * The reason the bank account status changed to the current value.
     */
    @JsonProperty("statusReason")
    private BankAccountStatusReason statusReason;

    /**
     * Reason for, and details related to, an `errored` or `verificationFailed` bank account status.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("exceptionDetails")
    private Optional<? extends BankAccountException> exceptionDetails;

    @JsonCreator
    public WebhookDataBankAccountUpdated(
            @JsonProperty("bankAccountID") String bankAccountID,
            @JsonProperty("accountID") String accountID,
            @JsonProperty("status") BankAccountStatus status,
            @JsonProperty("statusReason") BankAccountStatusReason statusReason,
            @JsonProperty("exceptionDetails") Optional<? extends BankAccountException> exceptionDetails) {
        Utils.checkNotNull(bankAccountID, "bankAccountID");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(statusReason, "statusReason");
        Utils.checkNotNull(exceptionDetails, "exceptionDetails");
        this.bankAccountID = bankAccountID;
        this.accountID = accountID;
        this.status = status;
        this.statusReason = statusReason;
        this.exceptionDetails = exceptionDetails;
    }
    
    public WebhookDataBankAccountUpdated(
            String bankAccountID,
            String accountID,
            BankAccountStatus status,
            BankAccountStatusReason statusReason) {
        this(bankAccountID, accountID, status,
            statusReason, Optional.empty());
    }

    @JsonIgnore
    public String bankAccountID() {
        return bankAccountID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public BankAccountStatus status() {
        return status;
    }

    /**
     * The reason the bank account status changed to the current value.
     */
    @JsonIgnore
    public BankAccountStatusReason statusReason() {
        return statusReason;
    }

    /**
     * Reason for, and details related to, an `errored` or `verificationFailed` bank account status.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<BankAccountException> exceptionDetails() {
        return (Optional<BankAccountException>) exceptionDetails;
    }

    public static Builder builder() {
        return new Builder();
    }


    public WebhookDataBankAccountUpdated withBankAccountID(String bankAccountID) {
        Utils.checkNotNull(bankAccountID, "bankAccountID");
        this.bankAccountID = bankAccountID;
        return this;
    }

    public WebhookDataBankAccountUpdated withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataBankAccountUpdated withStatus(BankAccountStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The reason the bank account status changed to the current value.
     */
    public WebhookDataBankAccountUpdated withStatusReason(BankAccountStatusReason statusReason) {
        Utils.checkNotNull(statusReason, "statusReason");
        this.statusReason = statusReason;
        return this;
    }

    /**
     * Reason for, and details related to, an `errored` or `verificationFailed` bank account status.
     */
    public WebhookDataBankAccountUpdated withExceptionDetails(BankAccountException exceptionDetails) {
        Utils.checkNotNull(exceptionDetails, "exceptionDetails");
        this.exceptionDetails = Optional.ofNullable(exceptionDetails);
        return this;
    }


    /**
     * Reason for, and details related to, an `errored` or `verificationFailed` bank account status.
     */
    public WebhookDataBankAccountUpdated withExceptionDetails(Optional<? extends BankAccountException> exceptionDetails) {
        Utils.checkNotNull(exceptionDetails, "exceptionDetails");
        this.exceptionDetails = exceptionDetails;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataBankAccountUpdated other = (WebhookDataBankAccountUpdated) o;
        return 
            Utils.enhancedDeepEquals(this.bankAccountID, other.bankAccountID) &&
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.statusReason, other.statusReason) &&
            Utils.enhancedDeepEquals(this.exceptionDetails, other.exceptionDetails);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            bankAccountID, accountID, status,
            statusReason, exceptionDetails);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataBankAccountUpdated.class,
                "bankAccountID", bankAccountID,
                "accountID", accountID,
                "status", status,
                "statusReason", statusReason,
                "exceptionDetails", exceptionDetails);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String bankAccountID;

        private String accountID;

        private BankAccountStatus status;

        private BankAccountStatusReason statusReason;

        private Optional<? extends BankAccountException> exceptionDetails = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder bankAccountID(String bankAccountID) {
            Utils.checkNotNull(bankAccountID, "bankAccountID");
            this.bankAccountID = bankAccountID;
            return this;
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder status(BankAccountStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * The reason the bank account status changed to the current value.
         */
        public Builder statusReason(BankAccountStatusReason statusReason) {
            Utils.checkNotNull(statusReason, "statusReason");
            this.statusReason = statusReason;
            return this;
        }


        /**
         * Reason for, and details related to, an `errored` or `verificationFailed` bank account status.
         */
        public Builder exceptionDetails(BankAccountException exceptionDetails) {
            Utils.checkNotNull(exceptionDetails, "exceptionDetails");
            this.exceptionDetails = Optional.ofNullable(exceptionDetails);
            return this;
        }

        /**
         * Reason for, and details related to, an `errored` or `verificationFailed` bank account status.
         */
        public Builder exceptionDetails(Optional<? extends BankAccountException> exceptionDetails) {
            Utils.checkNotNull(exceptionDetails, "exceptionDetails");
            this.exceptionDetails = exceptionDetails;
            return this;
        }

        public WebhookDataBankAccountUpdated build() {

            return new WebhookDataBankAccountUpdated(
                bankAccountID, accountID, status,
                statusReason, exceptionDetails);
        }

    }
}
