/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class VolumeShareByCustomerTypeError {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("business")
    private Optional<String> business;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("consumer")
    private Optional<String> consumer;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("p2p")
    private Optional<String> p2p;

    @JsonCreator
    public VolumeShareByCustomerTypeError(
            @JsonProperty("business") Optional<String> business,
            @JsonProperty("consumer") Optional<String> consumer,
            @JsonProperty("p2p") Optional<String> p2p) {
        Utils.checkNotNull(business, "business");
        Utils.checkNotNull(consumer, "consumer");
        Utils.checkNotNull(p2p, "p2p");
        this.business = business;
        this.consumer = consumer;
        this.p2p = p2p;
    }
    
    public VolumeShareByCustomerTypeError() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> business() {
        return business;
    }

    @JsonIgnore
    public Optional<String> consumer() {
        return consumer;
    }

    @JsonIgnore
    public Optional<String> p2p() {
        return p2p;
    }

    public static Builder builder() {
        return new Builder();
    }


    public VolumeShareByCustomerTypeError withBusiness(String business) {
        Utils.checkNotNull(business, "business");
        this.business = Optional.ofNullable(business);
        return this;
    }


    public VolumeShareByCustomerTypeError withBusiness(Optional<String> business) {
        Utils.checkNotNull(business, "business");
        this.business = business;
        return this;
    }

    public VolumeShareByCustomerTypeError withConsumer(String consumer) {
        Utils.checkNotNull(consumer, "consumer");
        this.consumer = Optional.ofNullable(consumer);
        return this;
    }


    public VolumeShareByCustomerTypeError withConsumer(Optional<String> consumer) {
        Utils.checkNotNull(consumer, "consumer");
        this.consumer = consumer;
        return this;
    }

    public VolumeShareByCustomerTypeError withP2p(String p2p) {
        Utils.checkNotNull(p2p, "p2p");
        this.p2p = Optional.ofNullable(p2p);
        return this;
    }


    public VolumeShareByCustomerTypeError withP2p(Optional<String> p2p) {
        Utils.checkNotNull(p2p, "p2p");
        this.p2p = p2p;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        VolumeShareByCustomerTypeError other = (VolumeShareByCustomerTypeError) o;
        return 
            Utils.enhancedDeepEquals(this.business, other.business) &&
            Utils.enhancedDeepEquals(this.consumer, other.consumer) &&
            Utils.enhancedDeepEquals(this.p2p, other.p2p);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            business, consumer, p2p);
    }
    
    @Override
    public String toString() {
        return Utils.toString(VolumeShareByCustomerTypeError.class,
                "business", business,
                "consumer", consumer,
                "p2p", p2p);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> business = Optional.empty();

        private Optional<String> consumer = Optional.empty();

        private Optional<String> p2p = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder business(String business) {
            Utils.checkNotNull(business, "business");
            this.business = Optional.ofNullable(business);
            return this;
        }

        public Builder business(Optional<String> business) {
            Utils.checkNotNull(business, "business");
            this.business = business;
            return this;
        }


        public Builder consumer(String consumer) {
            Utils.checkNotNull(consumer, "consumer");
            this.consumer = Optional.ofNullable(consumer);
            return this;
        }

        public Builder consumer(Optional<String> consumer) {
            Utils.checkNotNull(consumer, "consumer");
            this.consumer = consumer;
            return this;
        }


        public Builder p2p(String p2p) {
            Utils.checkNotNull(p2p, "p2p");
            this.p2p = Optional.ofNullable(p2p);
            return this;
        }

        public Builder p2p(Optional<String> p2p) {
            Utils.checkNotNull(p2p, "p2p");
            this.p2p = p2p;
            return this;
        }

        public VolumeShareByCustomerTypeError build() {

            return new VolumeShareByCustomerTypeError(
                business, consumer, p2p);
        }

    }
}
