/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class VolumeShareByCustomerType {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("business")
    private Optional<Integer> business;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("consumer")
    private Optional<Integer> consumer;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("p2p")
    private Optional<Integer> p2p;

    @JsonCreator
    public VolumeShareByCustomerType(
            @JsonProperty("business") Optional<Integer> business,
            @JsonProperty("consumer") Optional<Integer> consumer,
            @JsonProperty("p2p") Optional<Integer> p2p) {
        Utils.checkNotNull(business, "business");
        Utils.checkNotNull(consumer, "consumer");
        Utils.checkNotNull(p2p, "p2p");
        this.business = business;
        this.consumer = consumer;
        this.p2p = p2p;
    }
    
    public VolumeShareByCustomerType() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Integer> business() {
        return business;
    }

    @JsonIgnore
    public Optional<Integer> consumer() {
        return consumer;
    }

    @JsonIgnore
    public Optional<Integer> p2p() {
        return p2p;
    }

    public static Builder builder() {
        return new Builder();
    }


    public VolumeShareByCustomerType withBusiness(int business) {
        Utils.checkNotNull(business, "business");
        this.business = Optional.ofNullable(business);
        return this;
    }


    public VolumeShareByCustomerType withBusiness(Optional<Integer> business) {
        Utils.checkNotNull(business, "business");
        this.business = business;
        return this;
    }

    public VolumeShareByCustomerType withConsumer(int consumer) {
        Utils.checkNotNull(consumer, "consumer");
        this.consumer = Optional.ofNullable(consumer);
        return this;
    }


    public VolumeShareByCustomerType withConsumer(Optional<Integer> consumer) {
        Utils.checkNotNull(consumer, "consumer");
        this.consumer = consumer;
        return this;
    }

    public VolumeShareByCustomerType withP2p(int p2p) {
        Utils.checkNotNull(p2p, "p2p");
        this.p2p = Optional.ofNullable(p2p);
        return this;
    }


    public VolumeShareByCustomerType withP2p(Optional<Integer> p2p) {
        Utils.checkNotNull(p2p, "p2p");
        this.p2p = p2p;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        VolumeShareByCustomerType other = (VolumeShareByCustomerType) o;
        return 
            Utils.enhancedDeepEquals(this.business, other.business) &&
            Utils.enhancedDeepEquals(this.consumer, other.consumer) &&
            Utils.enhancedDeepEquals(this.p2p, other.p2p);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            business, consumer, p2p);
    }
    
    @Override
    public String toString() {
        return Utils.toString(VolumeShareByCustomerType.class,
                "business", business,
                "consumer", consumer,
                "p2p", p2p);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<Integer> business = Optional.empty();

        private Optional<Integer> consumer = Optional.empty();

        private Optional<Integer> p2p = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder business(int business) {
            Utils.checkNotNull(business, "business");
            this.business = Optional.ofNullable(business);
            return this;
        }

        public Builder business(Optional<Integer> business) {
            Utils.checkNotNull(business, "business");
            this.business = business;
            return this;
        }


        public Builder consumer(int consumer) {
            Utils.checkNotNull(consumer, "consumer");
            this.consumer = Optional.ofNullable(consumer);
            return this;
        }

        public Builder consumer(Optional<Integer> consumer) {
            Utils.checkNotNull(consumer, "consumer");
            this.consumer = consumer;
            return this;
        }


        public Builder p2p(int p2p) {
            Utils.checkNotNull(p2p, "p2p");
            this.p2p = Optional.ofNullable(p2p);
            return this;
        }

        public Builder p2p(Optional<Integer> p2p) {
            Utils.checkNotNull(p2p, "p2p");
            this.p2p = p2p;
            return this;
        }

        public VolumeShareByCustomerType build() {

            return new VolumeShareByCustomerType(
                business, consumer, p2p);
        }

    }
}
